/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk.examples;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.Entry;
import com.unboundid.scim.data.Manager;
import com.unboundid.scim.data.Name;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.data.UserResource;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMEndpoint;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.SCIMService;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.core.MediaType;

public class ClientExample {
    public static final ResourceFactory<DeviceResource> DEVICE_RESOURCE_FACTORY = new ResourceFactory<DeviceResource>(){

        @Override
        public DeviceResource createResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            return new DeviceResource(resourceDescriptor, scimObject);
        }
    };

    public static void main(String[] args) throws Exception {
        Manager manager;
        Collection<Entry<String>> phoneNumbers;
        URI uri = URI.create("https://localhost:8443");
        SCIMService scimService = new SCIMService(uri, "bjensen", "password");
        scimService.setAcceptType(MediaType.APPLICATION_JSON_TYPE);
        SCIMEndpoint<UserResource> endpoint = scimService.getUserEndpoint();
        Resources<UserResource> resources = endpoint.query("userName eq \"bjensen\"");
        if (resources.getItemsPerPage() == 0) {
            System.out.println("User bjensen not found");
            return;
        }
        UserResource user = resources.iterator().next();
        Name name = user.getName();
        if (name != null) {
            System.out.println(name);
        }
        if ((phoneNumbers = user.getPhoneNumbers()) != null) {
            for (Entry<String> phoneNumber : phoneNumbers) {
                System.out.println(phoneNumber);
            }
        }
        if ((manager = user.getSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "manager", Manager.MANAGER_RESOLVER)) == null) {
            resources = endpoint.query("userName eq \"jsmith\"");
            if (resources.getItemsPerPage() > 0) {
                UserResource boss = resources.iterator().next();
                manager = new Manager(boss.getId(), null);
            } else {
                System.out.println("User jsmith not found");
            }
        }
        user.setSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "manager", Manager.MANAGER_RESOLVER, manager);
        String employeeNumber = user.getSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "employeeNumber", AttributeValueResolver.STRING_RESOLVER);
        if (employeeNumber != null) {
            System.out.println("employeeNumber: " + employeeNumber);
        }
        user.setSingularAttributeValue("urn:scim:schemas:extension:enterprise:1.0", "department", AttributeValueResolver.STRING_RESOLVER, "sales");
        user.setTitle("Vice President");
        endpoint.update(user);
        user = endpoint.get(user.getId());
        ResourceDescriptor deviceDescriptor = scimService.getResourceDescriptor("Device", null);
        SCIMEndpoint<DeviceResource> deviceEndpoint = scimService.getEndpoint(deviceDescriptor, DEVICE_RESOURCE_FACTORY);
    }

    public static class DeviceResource
    extends BaseResource {
        public DeviceResource(ResourceDescriptor resourceDescriptor) {
            super(resourceDescriptor);
        }

        public DeviceResource(ResourceDescriptor resourceDescriptor, SCIMObject scimObject) {
            super(resourceDescriptor, scimObject);
        }

        public String getVendorName() {
            return this.getSingularAttributeValue("urn:com:example:device:1.0", "vendorName", AttributeValueResolver.STRING_RESOLVER);
        }
    }
}

