/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.tools;

import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMEndpoint;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.ValuePattern;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRateThread
extends Thread {
    private final AtomicBoolean stopRequested;
    private final AtomicLong resourceCounter;
    private final AtomicLong errorCounter;
    private final AtomicLong queryCounter;
    private final AtomicLong queryDurations;
    private final AtomicReference<Thread> queryThread;
    private SCIMEndpoint<? extends BaseResource> client;
    private final AtomicReference<ResultCode> resultCode;
    private final CyclicBarrier startBarrier;
    private final String[] attributes;
    private final ValuePattern filterPattern;
    private final boolean isQuery;
    private final FixedRateBarrier fixedRateBarrier;

    QueryRateThread(int threadNumber, boolean isQuery, SCIMEndpoint<? extends BaseResource> client, ValuePattern filterPattern, String[] attributes, CyclicBarrier startBarrier, AtomicLong queryCounter, AtomicLong resourceCounter, AtomicLong queryDurations, AtomicLong errorCounter, FixedRateBarrier rateBarrier) {
        this.setName("QueryRate Thread " + threadNumber);
        this.setDaemon(true);
        this.client = client;
        this.isQuery = isQuery;
        this.filterPattern = filterPattern;
        this.attributes = attributes;
        this.queryCounter = queryCounter;
        this.resourceCounter = resourceCounter;
        this.queryDurations = queryDurations;
        this.errorCounter = errorCounter;
        this.startBarrier = startBarrier;
        this.fixedRateBarrier = rateBarrier;
        this.resultCode = new AtomicReference<Object>(null);
        this.queryThread = new AtomicReference<Object>(null);
        this.stopRequested = new AtomicBoolean(false);
    }

    @Override
    public void run() {
        this.queryThread.set(QueryRateThread.currentThread());
        try {
            this.startBarrier.await();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        while (!this.stopRequested.get()) {
            if (this.fixedRateBarrier != null) {
                this.fixedRateBarrier.await();
            }
            String filterValue = this.filterPattern != null ? this.filterPattern.nextValue() : null;
            long startTime = System.nanoTime();
            try {
                if (this.isQuery) {
                    Resources<? extends BaseResource> resources = this.client.query(filterValue, null, null, this.attributes);
                    if (resources != null) {
                        this.resourceCounter.addAndGet(resources.getItemsPerPage());
                    }
                } else {
                    this.client.get(filterValue, null, this.attributes);
                    this.resourceCounter.incrementAndGet();
                }
            }
            catch (SCIMException e) {
                Debug.debugException(e);
                this.errorCounter.incrementAndGet();
                ResultCode rc = ResultCode.OTHER;
                this.resultCode.compareAndSet(null, rc);
            }
            catch (RuntimeException e) {
                Debug.debugException(e);
                if (this.stopRequested.get()) break;
                throw e;
            }
            this.queryCounter.incrementAndGet();
            this.queryDurations.addAndGet(System.nanoTime() - startTime);
        }
        this.queryThread.set(null);
    }

    void signalShutdown() {
        this.stopRequested.set(true);
        if (this.fixedRateBarrier != null) {
            this.fixedRateBarrier.shutdownRequested();
        }
    }

    ResultCode waitForShutdown() {
        Thread t = this.queryThread.get();
        if (t != null) {
            try {
                t.join();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.resultCode.compareAndSet(null, ResultCode.SUCCESS);
        return this.resultCode.get();
    }
}

