/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.wink.ResourceStats;
import com.unboundid.scim.wink.SCIMApplication;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONStringer;
import org.json.JSONWriter;

@Path(value="monitor")
public class MonitorResource {
    private static final String RESOURCE_NAME = "monitor";
    private final SCIMApplication application;

    public MonitorResource(SCIMApplication application) {
        this.application = application;
    }

    @GET
    @Produces(value={"application/json"})
    public Response doJsonGet() {
        try {
            JSONStringer writer = new JSONStringer();
            this.writeMonitorData((JSONWriter)writer);
            this.application.getStatsForResource(RESOURCE_NAME).incrementStat("get-response-json");
            this.application.getStatsForResource(RESOURCE_NAME).incrementStat("get-successful");
            return Response.ok((Object)writer.toString(), (String)"application/json").build();
        }
        catch (JSONException e) {
            Debug.debugException(e);
            this.application.getStatsForResource(RESOURCE_NAME).incrementStat("get-500");
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private void writeMonitorData(JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("version");
        writer.value((Object)"1.8.15");
        writer.key("build");
        writer.value((Object)"20161107133251Z");
        writer.key("revision");
        writer.value((Object)"91c14");
        writer.key("resources");
        writer.array();
        for (ResourceStats stats : this.application.getResourceStats()) {
            writer.object();
            writer.key("name");
            writer.value((Object)stats.getName());
            for (Map.Entry<String, Long> stat : stats.getStats().entrySet()) {
                writer.key(stat.getKey());
                writer.value((Object)stat.getValue());
            }
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }
}

