/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import com.unboundid.scim.data.AuthenticationScheme;
import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.data.ChangePasswordConfig;
import com.unboundid.scim.data.ETagConfig;
import com.unboundid.scim.data.FilterConfig;
import com.unboundid.scim.data.PatchConfig;
import com.unboundid.scim.data.ServiceProviderConfig;
import com.unboundid.scim.data.SortConfig;
import com.unboundid.scim.data.XmlDataFormatConfig;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.sdk.OAuthTokenHandler;
import com.unboundid.scim.sdk.SCIMBackend;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.wink.AdjustableSemaphore;
import com.unboundid.scim.wink.BulkResource;
import com.unboundid.scim.wink.JSONBulkResource;
import com.unboundid.scim.wink.JSONQueryResource;
import com.unboundid.scim.wink.JSONServiceProviderConfigResource;
import com.unboundid.scim.wink.MonitorResource;
import com.unboundid.scim.wink.ResourceStats;
import com.unboundid.scim.wink.RootResource;
import com.unboundid.scim.wink.SCIMResource;
import com.unboundid.scim.wink.ServiceProviderConfigResource;
import com.unboundid.scim.wink.XMLBulkResource;
import com.unboundid.scim.wink.XMLQueryResource;
import com.unboundid.scim.wink.XMLServiceProviderConfigResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.common.WinkApplication;
import org.glassfish.jersey.server.filter.HttpMethodOverrideFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCIMApplication
extends WinkApplication {
    private final Map<String, ResourceStats> resourceStats;
    private final SCIMBackend backend;
    private final boolean supportsOAuth;
    private volatile long bulkMaxOperations = Long.MAX_VALUE;
    private volatile long bulkMaxPayloadSize = Long.MAX_VALUE;
    private volatile File tmpDataDir = null;
    private AdjustableSemaphore bulkMaxConcurrentRequestsSemaphore = new AdjustableSemaphore(Integer.MAX_VALUE);

    public SCIMApplication(SCIMBackend backend, OAuthTokenHandler tokenHandler) {
        this.register(new RootResource(this));
        this.register(new MonitorResource(this));
        this.register(new ServiceProviderConfigResource(this));
        this.register(new XMLServiceProviderConfigResource(this));
        this.register(new JSONServiceProviderConfigResource(this));
        this.register(new BulkResource(this, tokenHandler));
        this.register(new JSONBulkResource(this, tokenHandler));
        this.register(new XMLBulkResource(this, tokenHandler));
        this.register(new SCIMResource(this, tokenHandler));
        this.register(new XMLQueryResource(this, tokenHandler));
        this.register(new JSONQueryResource(this, tokenHandler));
        this.register(new HttpMethodOverrideFilter(new HttpMethodOverrideFilter.Source[0]));
        this.resourceStats = new HashMap<String, ResourceStats>();
        this.backend = backend;
        this.supportsOAuth = tokenHandler != null;
    }

    public Collection<ResourceStats> getResourceStats() {
        return Collections.unmodifiableCollection(this.resourceStats.values());
    }

    public ResourceStats getStatsForResource(String resourceName) {
        ResourceStats stats = this.resourceStats.get(resourceName);
        if (stats == null) {
            stats = new ResourceStats(resourceName);
            this.resourceStats.put(resourceName, stats);
        }
        return stats;
    }

    public ServiceProviderConfig getServiceProviderConfig() {
        SCIMObject scimObject = new SCIMObject();
        ServiceProviderConfig serviceProviderConfig = ServiceProviderConfig.SERVICE_PROVIDER_CONFIG_RESOURCE_FACTORY.createResource(CoreSchema.SERVICE_PROVIDER_CONFIG_SCHEMA_DESCRIPTOR, scimObject);
        serviceProviderConfig.setId("urn:scim:schemas:core:1.0");
        serviceProviderConfig.setPatchConfig(new PatchConfig(true));
        serviceProviderConfig.setBulkConfig(new BulkConfig(true, this.bulkMaxOperations, this.bulkMaxPayloadSize));
        serviceProviderConfig.setFilterConfig(new FilterConfig(true, this.backend.getConfig().getMaxResults()));
        serviceProviderConfig.setChangePasswordConfig(new ChangePasswordConfig(true));
        serviceProviderConfig.setSortConfig(new SortConfig(this.backend.supportsSorting()));
        serviceProviderConfig.setETagConfig(new ETagConfig(this.backend.supportsVersioning()));
        ArrayList<AuthenticationScheme> authenticationSchemes = new ArrayList<AuthenticationScheme>();
        authenticationSchemes.addAll(this.backend.getSupportedAuthenticationSchemes());
        if (this.supportsOAuth) {
            authenticationSchemes.add(AuthenticationScheme.createOAuth2(false));
        }
        serviceProviderConfig.setAuthenticationSchemes(authenticationSchemes);
        serviceProviderConfig.setXmlDataFormatConfig(new XmlDataFormatConfig(true));
        return serviceProviderConfig;
    }

    public SCIMBackend getBackend() {
        return this.backend;
    }

    public void setBulkMaxOperations(long bulkMaxOperations) {
        this.bulkMaxOperations = bulkMaxOperations;
    }

    public void setBulkMaxPayloadSize(long bulkMaxPayloadSize) {
        this.bulkMaxPayloadSize = bulkMaxPayloadSize;
    }

    public void setBulkMaxConcurrentRequests(int bulkMaxConcurrentRequests) {
        this.bulkMaxConcurrentRequestsSemaphore.setMaxPermits(bulkMaxConcurrentRequests);
    }

    public File getTmpDataDir() {
        return this.tmpDataDir;
    }

    public void setTmpDataDir(File tmpDataDir) {
        this.tmpDataDir = tmpDataDir;
    }

    public void acquireBulkRequestPermit() throws SCIMException {
        if (!this.bulkMaxConcurrentRequestsSemaphore.tryAcquire()) {
            throw SCIMException.createException(503, "The server is currently processing the maximum number of concurrent bulk requests (" + this.bulkMaxConcurrentRequestsSemaphore.getMaxPermits() + ")");
        }
    }

    public void releaseBulkRequestPermit() {
        this.bulkMaxConcurrentRequestsSemaphore.release();
    }
}

