/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.utils.Parser;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Path
implements Iterable<Element> {
    private final String schemaUrn;
    private final List<Element> elements;

    private Path(String schemaUrn, List<Element> elements) {
        this.schemaUrn = schemaUrn;
        this.elements = Collections.unmodifiableList(elements);
    }

    public Path attribute(String attribute) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.add(new Element(attribute, null));
        return new Path(this.schemaUrn, newElements);
    }

    public Path attribute(String attribute, Filter valueFilter) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.add(new Element(attribute, valueFilter));
        return new Path(this.schemaUrn, newElements);
    }

    public Path attribute(Path path) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements.size() + path.size());
        newElements.addAll(this.elements);
        newElements.addAll(path.elements);
        return new Path(this.schemaUrn, newElements);
    }

    public Path replace(int index, String attribute, Filter valueFilter) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.set(index, new Element(attribute, valueFilter));
        return new Path(this.schemaUrn, newElements);
    }

    public Path replace(int index, String attribute) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.set(index, new Element(attribute, this.elements.get(index).getValueFilter()));
        return new Path(this.schemaUrn, newElements);
    }

    public Path replace(int index, Filter valueFilter) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.set(index, new Element(this.elements.get(index).getAttribute(), valueFilter));
        return new Path(this.schemaUrn, newElements);
    }

    public Path subPath(int index) throws IndexOutOfBoundsException {
        return new Path(this.schemaUrn, this.elements.subList(0, index));
    }

    @Override
    public Iterator<Element> iterator() {
        return this.elements.iterator();
    }

    public Element getElement(int index) throws IndexOutOfBoundsException {
        return this.elements.get(index);
    }

    public boolean isRoot() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    public Path withoutFilters() {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements.size());
        for (Element element : this.elements) {
            newElements.add(new Element(element.getAttribute(), null));
        }
        return new Path(this.schemaUrn, newElements);
    }

    @JsonCreator
    public static Path fromString(String pathString) throws BadRequestException {
        return Parser.parsePath(pathString);
    }

    public static Path root() {
        return new Path(null, Collections.emptyList());
    }

    public static Path root(String schemaUrn) {
        if (schemaUrn != null && !SchemaUtils.isUrn(schemaUrn)) {
            throw new IllegalArgumentException(String.format("Invalid extension schema URN: %s", schemaUrn));
        }
        return new Path(schemaUrn, Collections.emptyList());
    }

    public static <T> Path root(Class<T> extensionClass) {
        return Path.root(SchemaUtils.getSchemaUrn(extensionClass));
    }

    public String getSchemaUrn() {
        return this.schemaUrn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        if (this.schemaUrn != null ? !this.schemaUrn.equalsIgnoreCase(path.schemaUrn) : path.schemaUrn != null) {
            return false;
        }
        return this.elements.equals(path.elements);
    }

    public int hashCode() {
        int result = this.schemaUrn != null ? StaticUtils.toLowerCase(this.schemaUrn).hashCode() : 0;
        result = 31 * result + this.elements.hashCode();
        return result;
    }

    @JsonValue
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        if (this.schemaUrn != null) {
            builder.append(this.schemaUrn);
            builder.append(":");
        }
        Iterator<Element> i = this.elements.iterator();
        while (i.hasNext()) {
            i.next().toString(builder);
            if (!i.hasNext()) continue;
            builder.append(".");
        }
    }

    public static final class Element {
        private final String attribute;
        private final Filter valueFilter;

        private Element(String attribute, Filter valueFilter) {
            this.attribute = attribute;
            this.valueFilter = valueFilter;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Filter getValueFilter() {
            return this.valueFilter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element element = (Element)o;
            if (!StaticUtils.toLowerCase(this.attribute).equals(StaticUtils.toLowerCase(element.attribute))) {
                return false;
            }
            return !(this.valueFilter != null ? !this.valueFilter.equals(element.valueFilter) : element.valueFilter != null);
        }

        public int hashCode() {
            int result = StaticUtils.toLowerCase(this.attribute).hashCode();
            result = 31 * result + (this.valueFilter != null ? this.valueFilter.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.toString(builder);
            return builder.toString();
        }

        public void toString(StringBuilder builder) {
            builder.append(this.attribute);
            if (this.valueFilter != null) {
                builder.append("[");
                builder.append(this.valueFilter);
                builder.append("]");
            }
        }
    }
}

