/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.exceptions;

import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ForbiddenException;
import com.unboundid.scim2.common.exceptions.MethodNotAllowedException;
import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.NotModifiedException;
import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.exceptions.ResourceConflictException;
import com.unboundid.scim2.common.exceptions.ResourceNotFoundException;
import com.unboundid.scim2.common.exceptions.ServerErrorException;
import com.unboundid.scim2.common.exceptions.UnauthorizedException;
import com.unboundid.scim2.common.messages.ErrorResponse;

public class ScimException
extends Exception {
    private final ErrorResponse scimError;

    public ScimException(int statusCode, String errorMessage) {
        this(statusCode, null, errorMessage);
    }

    public ScimException(int statusCode, String scimType, String errorMessage) {
        this.scimError = new ErrorResponse(statusCode);
        this.scimError.setScimType(scimType);
        this.scimError.setDetail(errorMessage);
    }

    public ScimException(int statusCode, String scimType, String errorMessage, Throwable cause) {
        super(cause);
        this.scimError = new ErrorResponse(statusCode);
        this.scimError.setScimType(scimType);
        this.scimError.setDetail(errorMessage);
    }

    public ScimException(ErrorResponse scimError, Throwable cause) {
        super(cause);
        this.scimError = scimError;
    }

    @Override
    public String getMessage() {
        return this.scimError.getDetail();
    }

    public ErrorResponse getScimError() {
        return this.scimError;
    }

    public static ScimException createException(int statusCode, String errorMessage) {
        return ScimException.createException(statusCode, errorMessage, null);
    }

    public static ScimException createException(int statusCode, String errorMessage, Exception cause) {
        ErrorResponse scimError = new ErrorResponse(statusCode);
        scimError.setDetail(errorMessage);
        return ScimException.createException(scimError, cause);
    }

    public static ScimException createException(ErrorResponse scimError, Exception cause) {
        switch (scimError.getStatus()) {
            case 304: {
                return new NotModifiedException(scimError, null, cause);
            }
            case 400: {
                return new BadRequestException(scimError, (Throwable)cause);
            }
            case 401: {
                return new UnauthorizedException(scimError, (Throwable)cause);
            }
            case 403: {
                return new ForbiddenException(scimError, (Throwable)cause);
            }
            case 404: {
                return new ResourceNotFoundException(scimError, (Throwable)cause);
            }
            case 405: {
                return new MethodNotAllowedException(scimError, (Throwable)cause);
            }
            case 409: {
                return new ResourceConflictException(scimError, (Throwable)cause);
            }
            case 412: {
                return new PreconditionFailedException(scimError, null, cause);
            }
            case 500: {
                return new ServerErrorException(scimError, (Throwable)cause);
            }
            case 501: {
                return new NotImplementedException(scimError, (Throwable)cause);
            }
        }
        return new ScimException(scimError, (Throwable)cause);
    }
}

