/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.filters;

import com.fasterxml.jackson.databind.node.ValueNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.AndFilter;
import com.unboundid.scim2.common.filters.ComplexValueFilter;
import com.unboundid.scim2.common.filters.ContainsFilter;
import com.unboundid.scim2.common.filters.EndsWithFilter;
import com.unboundid.scim2.common.filters.EqualFilter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.filters.GreaterThanFilter;
import com.unboundid.scim2.common.filters.GreaterThanOrEqualFilter;
import com.unboundid.scim2.common.filters.LessThanFilter;
import com.unboundid.scim2.common.filters.LessThanOrEqualFilter;
import com.unboundid.scim2.common.filters.NotEqualFilter;
import com.unboundid.scim2.common.filters.NotFilter;
import com.unboundid.scim2.common.filters.OrFilter;
import com.unboundid.scim2.common.filters.PresentFilter;
import com.unboundid.scim2.common.filters.StartsWithFilter;
import com.unboundid.scim2.common.utils.DateTimeUtils;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class Filter {
    public abstract FilterType getFilterType();

    public abstract <R, P> R visit(FilterVisitor<R, P> var1, P var2) throws ScimException;

    public abstract void toString(StringBuilder var1);

    public boolean isCombiningFilter() {
        return false;
    }

    public List<Filter> getCombinedFilters() {
        return null;
    }

    public boolean isNotFilter() {
        return false;
    }

    public Filter getInvertedFilter() {
        return null;
    }

    public boolean isComplexValueFilter() {
        return false;
    }

    public Filter getValueFilter() {
        return null;
    }

    public Path getAttributePath() {
        return null;
    }

    public boolean isComparisonFilter() {
        return false;
    }

    public ValueNode getComparisonValue() {
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public static Filter eq(Path attributePath, ValueNode filterValue) {
        return new EqualFilter(attributePath, filterValue);
    }

    public static Filter eq(String attributePath, Integer filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter eq(String attributePath, Long filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter eq(String attributePath, Double filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter eq(String attributePath, Float filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter eq(String attributePath, String filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    public static Filter eq(String attributePath, Boolean filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().booleanNode(filterValue.booleanValue()));
    }

    public static Filter eq(String attributePath, byte[] filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().binaryNode(filterValue));
    }

    public static Filter eq(String attributePath, Date filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    public static Filter ne(Path attributePath, ValueNode filterValue) {
        return new NotEqualFilter(attributePath, filterValue);
    }

    public static Filter ne(String attributePath, Integer filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter ne(String attributePath, Long filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter ne(String attributePath, Double filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter ne(String attributePath, Float filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter ne(String attributePath, String filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    public static Filter ne(String attributePath, Boolean filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().booleanNode(filterValue.booleanValue()));
    }

    public static Filter ne(String attributePath, byte[] filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().binaryNode(filterValue));
    }

    public static Filter ne(String attributePath, Date filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    public static Filter co(Path attributePath, ValueNode filterValue) {
        return new ContainsFilter(attributePath, filterValue);
    }

    public static Filter co(String attributePath, String filterValue) throws BadRequestException {
        return new ContainsFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    public static Filter sw(Path attributePath, ValueNode filterValue) {
        return new StartsWithFilter(attributePath, filterValue);
    }

    public static Filter sw(String attributePath, String filterValue) throws BadRequestException {
        return new StartsWithFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    public static Filter ew(Path attributePath, ValueNode filterValue) {
        return new EndsWithFilter(attributePath, filterValue);
    }

    public static Filter ew(String attributePath, String filterValue) throws BadRequestException {
        return new EndsWithFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    public static Filter pr(Path attributePath) {
        return new PresentFilter(attributePath);
    }

    public static Filter pr(String attributePath) throws BadRequestException {
        return new PresentFilter(Path.fromString(attributePath));
    }

    public static Filter gt(Path attributePath, ValueNode filterValue) {
        return new GreaterThanFilter(attributePath, filterValue);
    }

    public static Filter gt(String attributePath, Integer filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter gt(String attributePath, Long filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter gt(String attributePath, Double filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter gt(String attributePath, Float filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter gt(String attributePath, String filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    public static Filter gt(String attributePath, Date filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    public static Filter ge(Path attributePath, ValueNode filterValue) {
        return new GreaterThanOrEqualFilter(attributePath, filterValue);
    }

    public static Filter ge(String attributePath, Integer filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter ge(String attributePath, Long filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter ge(String attributePath, Double filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter ge(String attributePath, Float filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter ge(String attributePath, String filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    public static Filter ge(String attributePath, Date filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    public static Filter lt(Path attributePath, ValueNode filterValue) {
        return new LessThanFilter(attributePath, filterValue);
    }

    public static Filter lt(String attributePath, Integer filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter lt(String attributePath, Long filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter lt(String attributePath, Double filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter lt(String attributePath, Float filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter lt(String attributePath, String filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    public static Filter lt(String attributePath, Date filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    public static Filter le(Path attributePath, ValueNode filterValue) {
        return new LessThanOrEqualFilter(attributePath, filterValue);
    }

    public static Filter le(String attributePath, Integer filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter le(String attributePath, Long filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter le(String attributePath, Double filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter le(String attributePath, Float filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    public static Filter le(String attributePath, String filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    public static Filter le(String attributePath, Date filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    public static Filter and(Filter filter1, Filter filter2, Filter ... filters) {
        ArrayList<Filter> components = new ArrayList<Filter>(filters != null ? 2 + filters.length : 2);
        components.add(filter1);
        components.add(filter2);
        if (filters != null) {
            Collections.addAll(components, filters);
        }
        return new AndFilter(components);
    }

    public static Filter and(String filter1, String filter2, String ... filters) throws BadRequestException {
        ArrayList<Filter> components = new ArrayList<Filter>(filters != null ? 2 + filters.length : 2);
        components.add(Filter.fromString(filter1));
        components.add(Filter.fromString(filter2));
        if (filters != null) {
            for (String filter : filters) {
                components.add(Filter.fromString(filter));
            }
        }
        return new AndFilter(components);
    }

    public static Filter or(Filter filter1, Filter filter2, Filter ... filters) {
        ArrayList<Filter> components = new ArrayList<Filter>(filters != null ? 2 + filters.length : 2);
        components.add(filter1);
        components.add(filter2);
        if (filters != null) {
            Collections.addAll(components, filters);
        }
        return new OrFilter(components);
    }

    public static Filter or(String filter1, String filter2, String ... filters) throws BadRequestException {
        ArrayList<Filter> components = new ArrayList<Filter>(filters != null ? 2 + filters.length : 2);
        components.add(Filter.fromString(filter1));
        components.add(Filter.fromString(filter2));
        if (filters != null) {
            for (String filter : filters) {
                components.add(Filter.fromString(filter));
            }
        }
        return new OrFilter(components);
    }

    public static Filter and(List<Filter> filters) {
        if (filters.size() < 2) {
            throw new IllegalArgumentException("and logical filter must combine at least 2 filters");
        }
        return new AndFilter(new ArrayList<Filter>(filters));
    }

    public static Filter or(List<Filter> filters) {
        if (filters.size() < 2) {
            throw new IllegalArgumentException("or logical filter must combine at least 2 filters");
        }
        return new OrFilter(new ArrayList<Filter>(filters));
    }

    public static Filter not(Filter filter) {
        return new NotFilter(filter);
    }

    public static Filter not(String filter) throws BadRequestException {
        return new NotFilter(Filter.fromString(filter));
    }

    public static Filter hasComplexValue(Path attributePath, Filter valueFilter) {
        return new ComplexValueFilter(attributePath, valueFilter);
    }

    public static Filter hasComplexValue(String attributePath, Filter valueFilter) throws BadRequestException {
        return new ComplexValueFilter(Path.fromString(attributePath), valueFilter);
    }

    public static Filter hasComplexValue(String attributePath, String valueFilter) throws BadRequestException {
        return new ComplexValueFilter(Path.fromString(attributePath), Filter.fromString(valueFilter));
    }

    public static Filter fromString(String filterString) throws BadRequestException {
        return Parser.parseFilter(filterString);
    }
}

