/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.unboundid.scim2.common.BaseScimResource;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.utils.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Schema(id="urn:ietf:params:scim:api:messages:2.0:ListResponse", name="List Response", description="SCIM 2.0 List Response")
@JsonPropertyOrder(value={"schemas", "totalResults", "itemsPerPage", "startIndex", "Resources"})
public final class ListResponse<T>
extends BaseScimResource
implements Iterable<T> {
    @Attribute(description="The total number of results returned by the list or query operation")
    @JsonProperty(value="totalResults", required=true)
    private final int totalResults;
    @Attribute(description="The number of resources returned in a list response page")
    @JsonProperty(value="itemsPerPage")
    private final Integer itemsPerPage;
    @Attribute(description="The 1-based index of the first result in the current set of list results")
    @JsonProperty(value="startIndex")
    private final Integer startIndex;
    @Attribute(description="A multi-valued list of complex objects containing the requested resources")
    @JsonProperty(value="Resources", required=true)
    private final List<T> resources;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    public ListResponse(Map<String, Object> props) {
        TreeMap<String, Object> properties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        properties.putAll(props);
        this.checkRequiredProperties(properties, "totalResults", "resources");
        this.totalResults = (Integer)properties.get("totalResults");
        this.resources = (List)properties.get("resources");
        this.startIndex = properties.containsKey("startIndex") ? (Integer)properties.get("startIndex") : null;
        Integer n = this.itemsPerPage = properties.containsKey("itemsPerPage") ? (Integer)properties.get("itemsPerPage") : null;
        if (properties.containsKey("schemas")) {
            this.setSchemaUrns((Collection)properties.get("schemas"));
        }
    }

    public ListResponse(int totalResults, List<T> resources, Integer startIndex, Integer itemsPerPage) {
        this.totalResults = totalResults;
        this.startIndex = startIndex;
        this.itemsPerPage = itemsPerPage;
        ObjectReader reader = JsonUtils.getObjectReader();
        ObjectWriter writer = JsonUtils.getObjectWriter();
        try {
            String rawResources = writer.writeValueAsString(resources);
            this.resources = (List)reader.forType(new TypeReference<List<T>>(){}).readValue(rawResources);
        }
        catch (IOException ie) {
            throw new IllegalArgumentException("Resources exception", ie);
        }
    }

    public ListResponse(Collection<T> resources) {
        this.totalResults = resources.size();
        this.resources = new ArrayList<T>(resources);
        this.startIndex = null;
        this.itemsPerPage = null;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public List<T> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    public Iterator<T> iterator() {
        return this.resources.iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListResponse that = (ListResponse)o;
        if (this.totalResults != that.totalResults) {
            return false;
        }
        if (this.itemsPerPage != null ? !this.itemsPerPage.equals(that.itemsPerPage) : that.itemsPerPage != null) {
            return false;
        }
        if (!this.resources.equals(that.resources)) {
            return false;
        }
        return !(this.startIndex != null ? !this.startIndex.equals(that.startIndex) : that.startIndex != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.totalResults ^ this.totalResults >>> 32);
        result = 31 * result + this.resources.hashCode();
        result = 31 * result + (this.startIndex != null ? this.startIndex.hashCode() : 0);
        result = 31 * result + (this.itemsPerPage != null ? this.itemsPerPage.hashCode() : 0);
        return result;
    }

    private void checkRequiredProperties(Map<String, Object> properties, String ... requiredProperties) {
        for (String property : requiredProperties) {
            if (properties.containsKey(property)) continue;
            throw new IllegalStateException(String.format("Missing required creator property '%s'", property));
        }
    }
}

