/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public class AttributeDefinition {
    @Attribute(description="The attribute's name.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final String name;
    @Attribute(description="The attribute's data type.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final Type type;
    @Attribute(description="When an attribute is of type \"complex\", \"subAttributes\" defines set of sub-attributes.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE, multiValueClass=AttributeDefinition.class)
    private final Collection<AttributeDefinition> subAttributes;
    @Attribute(description="Boolean value indicating the attribute's plurality.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final boolean multiValued;
    @Attribute(description="The attribute's human readable description.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final String description;
    @Attribute(description="A Boolean value that specifies if the attribute is required.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final boolean required;
    @Attribute(description="A collection of suggested canonical values that MAY be used.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE, multiValueClass=String.class)
    private final Collection<String> canonicalValues;
    @Attribute(description="A Boolean value that specifies if the String attribute is case sensitive.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final boolean caseExact;
    @Attribute(description="A single keyword indicating the circumstances under which the value of the attribute can be (re)defined.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final Mutability mutability;
    @Attribute(description="A single keyword that indicates when an attribute and associated values are returned in response to a GET request or in response to a PUT, POST, or PATCH request.", isRequired=true, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final Returned returned;
    @Attribute(description="A single keyword value that specifies how the service provider enforces uniqueness of attribute values.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE)
    private final Uniqueness uniqueness;
    @Attribute(description="A multi-valued array of JSON strings that indicate the SCIM resource types that may be referenced.", isRequired=false, isCaseExact=false, mutability=Mutability.READ_ONLY, returned=Returned.DEFAULT, uniqueness=Uniqueness.NONE, multiValueClass=String.class)
    private final Collection<String> referenceTypes;

    @JsonCreator
    AttributeDefinition(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="type", required=true) Type type, @JsonProperty(value="subAttributes") Collection<AttributeDefinition> subAttributes, @JsonProperty(value="multiValued", required=true) boolean multiValued, @JsonProperty(value="description") String description, @JsonProperty(value="required", required=true) boolean required, @JsonProperty(value="canonicalValues") Collection<String> canonicalValues, @JsonProperty(value="caseExact") boolean caseExact, @JsonProperty(value="mutability", required=true) Mutability mutability, @JsonProperty(value="returned", required=true) Returned returned, @JsonProperty(value="uniqueness") Uniqueness uniqueness, @JsonProperty(value="referenceTypes") Collection<String> referenceTypes) {
        this.name = name;
        this.type = type;
        this.subAttributes = subAttributes == null ? null : Collections.unmodifiableList(new ArrayList<AttributeDefinition>(subAttributes));
        this.multiValued = multiValued;
        this.description = description;
        this.required = required;
        this.canonicalValues = canonicalValues == null ? null : Collections.unmodifiableList(new ArrayList<String>(canonicalValues));
        this.caseExact = caseExact;
        this.mutability = mutability;
        this.returned = returned;
        this.uniqueness = uniqueness;
        this.referenceTypes = referenceTypes == null ? null : Collections.unmodifiableList(new ArrayList<String>(referenceTypes));
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isCaseExact() {
        return this.caseExact;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<AttributeDefinition> getSubAttributes() {
        return this.subAttributes;
    }

    public Collection<String> getCanonicalValues() {
        return this.canonicalValues;
    }

    public Mutability getMutability() {
        return this.mutability;
    }

    public Returned getReturned() {
        return this.returned;
    }

    public Uniqueness getUniqueness() {
        return this.uniqueness;
    }

    public Collection<String> getReferenceTypes() {
        return this.referenceTypes;
    }

    public String toString() {
        return this.toIndentedString("");
    }

    private String toIndentedString(String indent) {
        StringBuilder builder = new StringBuilder();
        builder.append(indent);
        builder.append("Name: ");
        builder.append(this.getName());
        builder.append(" Description: ");
        builder.append(this.getDescription());
        builder.append(" Mutability: ");
        builder.append((Object)this.getMutability());
        builder.append(" isRequired: ");
        builder.append(this.isRequired());
        builder.append(" isCaseExact: ");
        builder.append(this.isCaseExact());
        builder.append(System.lineSeparator());
        if (this.getSubAttributes() != null) {
            for (AttributeDefinition a : this.getSubAttributes()) {
                builder.append(a.toIndentedString(indent + "  "));
            }
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeDefinition that = (AttributeDefinition)o;
        if (this.caseExact != that.caseExact) {
            return false;
        }
        if (this.multiValued != that.multiValued) {
            return false;
        }
        if (this.required != that.required) {
            return false;
        }
        if (this.canonicalValues != null ? !this.canonicalValues.equals(that.canonicalValues) : that.canonicalValues != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.mutability != null ? !this.mutability.equals((Object)that.mutability) : that.mutability != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.referenceTypes != null ? !this.referenceTypes.equals(that.referenceTypes) : that.referenceTypes != null) {
            return false;
        }
        if (this.returned != null ? !this.returned.equals((Object)that.returned) : that.returned != null) {
            return false;
        }
        if (this.subAttributes != null ? !this.subAttributes.equals(that.subAttributes) : that.subAttributes != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals((Object)that.type) : that.type != null) {
            return false;
        }
        return !(this.uniqueness != null ? !this.uniqueness.equals((Object)that.uniqueness) : that.uniqueness != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.subAttributes != null ? this.subAttributes.hashCode() : 0);
        result = 31 * result + (this.multiValued ? 1 : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.required ? 1 : 0);
        result = 31 * result + (this.canonicalValues != null ? this.canonicalValues.hashCode() : 0);
        result = 31 * result + (this.caseExact ? 1 : 0);
        result = 31 * result + (this.mutability != null ? this.mutability.hashCode() : 0);
        result = 31 * result + (this.returned != null ? this.returned.hashCode() : 0);
        result = 31 * result + (this.uniqueness != null ? this.uniqueness.hashCode() : 0);
        result = 31 * result + (this.referenceTypes != null ? this.referenceTypes.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String name;
        private Type type;
        private Collection<AttributeDefinition> subAttributes;
        private boolean multiValued;
        private String description;
        private boolean required;
        private Collection<String> canonicalValues;
        private boolean caseExact = false;
        private Mutability mutability = Mutability.READ_WRITE;
        private Returned returned = Returned.DEFAULT;
        private Uniqueness uniqueness;
        private Collection<String> referenceTypes;

        public Builder() {
            this.type = Type.STRING;
            this.mutability = Mutability.READ_WRITE;
            this.returned = Returned.DEFAULT;
            this.uniqueness = Uniqueness.NONE;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder addSubAttributes(AttributeDefinition ... subAttributes) {
            if (subAttributes != null && subAttributes.length > 0) {
                if (this.subAttributes == null) {
                    this.subAttributes = new LinkedList<AttributeDefinition>();
                }
                this.subAttributes.addAll(Arrays.asList(subAttributes));
            }
            return this;
        }

        public Builder setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder addCanonicalValues(String ... canonicalValues) {
            if (canonicalValues != null && canonicalValues.length > 0) {
                if (this.canonicalValues == null) {
                    this.canonicalValues = new HashSet<String>();
                }
                this.canonicalValues.addAll(Arrays.asList(canonicalValues));
            }
            return this;
        }

        public Builder setCaseExact(boolean caseExact) {
            this.caseExact = caseExact;
            return this;
        }

        public Builder setMutability(Mutability mutability) {
            this.mutability = mutability;
            return this;
        }

        public Builder setReturned(Returned returned) {
            this.returned = returned;
            return this;
        }

        public Builder setUniqueness(Uniqueness uniqueness) {
            this.uniqueness = uniqueness;
            return this;
        }

        public Builder addReferenceTypes(String ... referenceTypes) {
            if (referenceTypes != null && referenceTypes.length > 0) {
                if (this.referenceTypes == null) {
                    this.referenceTypes = new HashSet<String>();
                }
                this.referenceTypes.addAll(Arrays.asList(referenceTypes));
            }
            return this;
        }

        public Builder clear() {
            this.name = null;
            this.type = Type.STRING;
            this.subAttributes = null;
            this.multiValued = false;
            this.description = null;
            this.required = false;
            this.canonicalValues = null;
            this.caseExact = false;
            this.mutability = Mutability.READ_WRITE;
            this.returned = Returned.DEFAULT;
            this.uniqueness = Uniqueness.NONE;
            this.referenceTypes = null;
            return this;
        }

        public AttributeDefinition build() {
            return new AttributeDefinition(this.name, this.type, this.subAttributes, this.multiValued, this.description, this.required, this.canonicalValues, this.caseExact, this.mutability, this.returned, this.uniqueness, this.referenceTypes);
        }
    }

    public static enum Uniqueness {
        NONE("none"),
        SERVER("server"),
        GLOBAL("global");

        private String name;

        private Uniqueness(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        @JsonCreator
        public static Uniqueness fromName(String name) throws BadRequestException {
            for (Uniqueness uniqueness : Uniqueness.values()) {
                if (!uniqueness.getName().equalsIgnoreCase(name)) continue;
                return uniqueness;
            }
            throw BadRequestException.invalidSyntax("Unknown SCIM uniquenessConstraint");
        }
    }

    public static enum Returned {
        ALWAYS("always"),
        NEVER("never"),
        DEFAULT("default"),
        REQUEST("request");

        private String name;

        private Returned(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        @JsonCreator
        public static Returned fromName(String name) throws BadRequestException {
            for (Returned returned : Returned.values()) {
                if (!returned.getName().equalsIgnoreCase(name)) continue;
                return returned;
            }
            throw BadRequestException.invalidSyntax("Unknown SCIM return constraint");
        }
    }

    public static enum Mutability {
        READ_ONLY("readOnly"),
        READ_WRITE("readWrite"),
        IMMUTABLE("immutable"),
        WRITE_ONLY("writeOnly");

        private String name;

        private Mutability(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        @JsonCreator
        public static Mutability fromName(String name) throws BadRequestException {
            for (Mutability mutability : Mutability.values()) {
                if (!mutability.getName().equalsIgnoreCase(name)) continue;
                return mutability;
            }
            throw BadRequestException.invalidSyntax("Unknown SCIM mutability constraint");
        }
    }

    public static enum Type {
        STRING("string"),
        BOOLEAN("boolean"),
        DECIMAL("decimal"),
        INTEGER("integer"),
        DATETIME("dateTime"),
        BINARY("binary"),
        REFERENCE("reference"),
        COMPLEX("complex");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }

        @JsonCreator
        public static Type fromName(String name) {
            for (Type type : Type.values()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return type;
            }
            throw new RuntimeException("Unknown SCIM datatype");
        }
    }
}

