/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.utils.CaseIgnoreMap;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CaseIgnoreObjectNode
extends ObjectNode {
    public CaseIgnoreObjectNode(JsonNodeFactory nc) {
        super(nc, (Map)new CaseIgnoreMap());
    }

    public CaseIgnoreObjectNode(JsonNodeFactory nc, Map<String, JsonNode> kids) {
        super(nc, (Map)new CaseIgnoreMap(kids));
    }

    public ObjectNode deepCopy() {
        CaseIgnoreObjectNode ret = new CaseIgnoreObjectNode(this._nodeFactory);
        for (Map.Entry entry : this._children.entrySet()) {
            ret._children.put((String)entry.getKey(), ((JsonNode)entry.getValue()).deepCopy());
        }
        return ret;
    }

    public JsonNode findValue(String fieldName) {
        for (Map.Entry entry : this._children.entrySet()) {
            if (fieldName.equals(entry.getKey())) {
                return (JsonNode)entry.getValue();
            }
            JsonNode value = ((JsonNode)entry.getValue()).findValue(fieldName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public List<JsonNode> findValues(String fieldName, List<JsonNode> foundSoFar) {
        List localFoundSoFar = foundSoFar;
        for (Map.Entry entry : this._children.entrySet()) {
            if (StaticUtils.toLowerCase(fieldName).equals(StaticUtils.toLowerCase((String)entry.getKey()))) {
                if (localFoundSoFar == null) {
                    localFoundSoFar = new ArrayList<JsonNode>();
                }
                localFoundSoFar.add((JsonNode)((JsonNode)entry.getValue()));
                continue;
            }
            localFoundSoFar = ((JsonNode)entry.getValue()).findValues(fieldName, foundSoFar);
        }
        return localFoundSoFar;
    }

    public List<String> findValuesAsText(String fieldName, List<String> foundSoFar) {
        List localFoundSoFar = foundSoFar;
        for (Map.Entry entry : this._children.entrySet()) {
            if (StaticUtils.toLowerCase(fieldName).equals(StaticUtils.toLowerCase((String)entry.getKey()))) {
                if (localFoundSoFar == null) {
                    localFoundSoFar = new ArrayList<String>();
                }
                localFoundSoFar.add(((JsonNode)entry.getValue()).asText());
                continue;
            }
            localFoundSoFar = ((JsonNode)entry.getValue()).findValuesAsText(fieldName, foundSoFar);
        }
        return localFoundSoFar;
    }

    public ObjectNode findParent(String fieldName) {
        for (Map.Entry entry : this._children.entrySet()) {
            if (StaticUtils.toLowerCase(fieldName).equals(StaticUtils.toLowerCase((String)entry.getKey()))) {
                return this;
            }
            JsonNode value = ((JsonNode)entry.getValue()).findParent(fieldName);
            if (value == null) continue;
            return (ObjectNode)value;
        }
        return null;
    }

    public List<JsonNode> findParents(String fieldName, List<JsonNode> foundSoFar) {
        List localFoundSoFar = foundSoFar;
        for (Map.Entry entry : this._children.entrySet()) {
            if (StaticUtils.toLowerCase(fieldName).equals(StaticUtils.toLowerCase((String)entry.getKey()))) {
                if (localFoundSoFar == null) {
                    localFoundSoFar = new ArrayList<JsonNode>();
                }
                localFoundSoFar.add((JsonNode)this);
                continue;
            }
            localFoundSoFar = ((JsonNode)entry.getValue()).findParents(fieldName, foundSoFar);
        }
        return localFoundSoFar;
    }
}

