/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JFMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONObjectExactMatchingRule
extends MatchingRule {
    @NotNull
    private static final JSONObjectExactMatchingRule INSTANCE = new JSONObjectExactMatchingRule();
    private static final long serialVersionUID = -4476702301631553228L;

    @NotNull
    public static JSONObjectExactMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleName() {
        return "jsonObjectExactMatch";
    }

    @Override
    @NotNull
    public String getEqualityMatchingRuleOID() {
        return "1.3.6.1.4.1.30221.2.4.12";
    }

    @Override
    @Nullable
    public String getOrderingMatchingRuleName() {
        return null;
    }

    @Override
    @Nullable
    public String getOrderingMatchingRuleOID() {
        return null;
    }

    @Override
    @Nullable
    public String getSubstringMatchingRuleName() {
        return null;
    }

    @Override
    @Nullable
    public String getSubstringMatchingRuleOID() {
        return null;
    }

    @Override
    public boolean valuesMatch(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        JSONObject o2;
        JSONObject o1;
        try {
            o1 = new JSONObject(value1.stringValue());
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, e.getMessage(), e);
        }
        try {
            o2 = new JSONObject(value2.stringValue());
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, e.getMessage(), e);
        }
        return o1.equals(o2, false, true, false);
    }

    @Override
    public boolean matchesSubstring(@NotNull ASN1OctetString value, @Nullable ASN1OctetString subInitial, @Nullable ASN1OctetString[] subAny, @Nullable ASN1OctetString subFinal) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, JFMessages.ERR_JSON_MATCHING_RULE_SUBSTRING_NOT_SUPPORTED.get());
    }

    @Override
    public int compareValues(@NotNull ASN1OctetString value1, @NotNull ASN1OctetString value2) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, JFMessages.ERR_JSON_MATCHING_RULE_ORDERING_NOT_SUPPORTED.get());
    }

    @Override
    @NotNull
    public ASN1OctetString normalize(@NotNull ASN1OctetString value) throws LDAPException {
        JSONObject o;
        try {
            o = new JSONObject(value.stringValue());
        }
        catch (JSONException e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, e.getMessage(), e);
        }
        return new ASN1OctetString(o.toNormalizedString());
    }

    @Override
    @NotNull
    public ASN1OctetString normalizeSubstring(@NotNull ASN1OctetString value, byte substringType) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, JFMessages.ERR_JSON_MATCHING_RULE_SUBSTRING_NOT_SUPPORTED.get());
    }
}

