/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vaadin.collaborationengine.CollaborationEngine;
import com.vaadin.collaborationengine.CollaborationEngineConfiguration;
import com.vaadin.collaborationengine.FileHandler;
import com.vaadin.collaborationengine.LicenseEvent;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class LicenseHandler {
    static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_DATE;
    private final CollaborationEngine ce;
    private final FileHandler fileHandler;
    private final LicenseInfo license;
    final StatisticsInfo statistics;

    LicenseHandler(CollaborationEngine collaborationEngine) {
        this.ce = collaborationEngine;
        CollaborationEngineConfiguration configuration = collaborationEngine.getConfiguration();
        if (configuration.isLicenseCheckingEnabled()) {
            this.fileHandler = new FileHandler(configuration);
            this.license = this.fileHandler.readLicenseFile();
            this.statistics = this.fileHandler.readStatsFile();
            if (!this.license.key.equals(this.statistics.licenseKey)) {
                this.statistics.licenseKey = this.license.key;
                this.statistics.gracePeriodStart = null;
                this.statistics.licenseEvents.clear();
            }
            if (this.license.endDate.isBefore(this.getCurrentDate())) {
                CollaborationEngine.LOGGER.warn("Your Collaboration Engine license has expired. Your application will still continue to work, but the collaborative features will be disabled. Please contact Vaadin about obtaining a new, up-to-date license for your application. https://vaadin.com/collaboration");
            }
        } else {
            this.fileHandler = null;
            this.license = null;
            this.statistics = null;
        }
    }

    synchronized boolean registerUser(String userId) {
        boolean hasActiveSeat;
        LocalDate currentDate = this.getCurrentDate();
        if (this.isGracePeriodEnded(currentDate)) {
            this.fireLicenseEvent(LicenseEvent.LicenseEventType.GRACE_PERIOD_ENDED);
        }
        if (this.license.endDate.isBefore(currentDate)) {
            this.fireLicenseEvent(LicenseEvent.LicenseEventType.LICENSE_EXPIRED);
            return false;
        }
        if (this.license.endDate.minusDays(31L).isBefore(currentDate)) {
            this.fireLicenseEvent(LicenseEvent.LicenseEventType.LICENSE_EXPIRES_SOON);
        }
        Set users = this.statistics.statistics.computeIfAbsent(YearMonth.from(currentDate), yearMonth -> new LinkedHashSet());
        int effectiveQuota = this.isGracePeriodOngoing(currentDate) ? this.license.quota * 10 : this.license.quota;
        boolean bl = hasActiveSeat = users.size() <= effectiveQuota ? users.contains(userId) : users.stream().limit(effectiveQuota).anyMatch(user -> user.equals(userId));
        if (hasActiveSeat) {
            return true;
        }
        if (users.size() >= effectiveQuota) {
            if (this.statistics.gracePeriodStart != null) {
                return false;
            }
            this.statistics.gracePeriodStart = currentDate;
            this.fireLicenseEvent(LicenseEvent.LicenseEventType.GRACE_PERIOD_STARTED);
        }
        users.add(userId);
        this.fileHandler.writeStats(this.statistics);
        return true;
    }

    private boolean isGracePeriodOngoing(LocalDate currentDate) {
        return this.statistics.gracePeriodStart != null && !this.isGracePeriodEnded(currentDate);
    }

    private boolean isGracePeriodEnded(LocalDate currentDate) {
        return this.statistics.gracePeriodStart != null && currentDate.isAfter(this.getLastGracePeriodDate());
    }

    private LocalDate getLastGracePeriodDate() {
        return this.statistics.gracePeriodStart.plusDays(30L);
    }

    private void fireLicenseEvent(LicenseEvent.LicenseEventType type) {
        String message;
        if (this.statistics.licenseEvents.get((Object)type) != null) {
            return;
        }
        switch (type) {
            case GRACE_PERIOD_STARTED: {
                LocalDate gracePeriodEnd = this.getLastGracePeriodDate().plusDays(1L);
                message = type.createMessage(gracePeriodEnd.format(DATE_FORMATTER));
                break;
            }
            case LICENSE_EXPIRES_SOON: {
                message = type.createMessage(this.license.endDate.format(DATE_FORMATTER));
                break;
            }
            default: {
                message = type.createMessage(new Object[0]);
            }
        }
        LicenseEvent event = new LicenseEvent(this.ce, type, message);
        this.statistics.licenseEvents.put(type, this.getCurrentDate());
        this.fileHandler.writeStats(this.statistics);
        this.ce.getConfiguration().getLicenseEventHandler().handleLicenseEvent(event);
    }

    private LocalDate getCurrentDate() {
        return LocalDate.now(this.ce.getClock());
    }

    Map<YearMonth, Set<String>> getStatistics() {
        return this.statistics.copyMap(this.statistics.statistics);
    }

    static class StatisticsInfoWrapper {
        final StatisticsInfo content;
        final String checksum;

        @JsonCreator
        StatisticsInfoWrapper(@JsonProperty(value="content", required=true) StatisticsInfo content, @JsonProperty(value="checksum", required=true) String checksum) {
            this.content = content;
            this.checksum = checksum;
        }
    }

    static class StatisticsInfo {
        String licenseKey;
        Map<YearMonth, Set<String>> statistics;
        LocalDate gracePeriodStart;
        Map<LicenseEvent.LicenseEventType, LocalDate> licenseEvents;

        StatisticsInfo(@JsonProperty(value="licenseKey", required=true) String licenseKey, @JsonProperty(value="statistics", required=true) Map<YearMonth, List<String>> userIdsFromFile, @JsonProperty(value="gracePeriodStart") LocalDate gracePeriodStart, @JsonProperty(value="licenseEvents", required=true) Map<LicenseEvent.LicenseEventType, LocalDate> licenseEvents) {
            this.licenseKey = licenseKey;
            this.statistics = this.copyMap(userIdsFromFile);
            this.gracePeriodStart = gracePeriodStart;
            this.licenseEvents = new HashMap<LicenseEvent.LicenseEventType, LocalDate>(licenseEvents);
        }

        private Map<YearMonth, Set<String>> copyMap(Map<YearMonth, ? extends Collection<String>> map) {
            TreeMap<YearMonth, Set<String>> treeMap = new TreeMap<YearMonth, Set<String>>();
            for (Map.Entry<YearMonth, ? extends Collection<String>> month : map.entrySet()) {
                treeMap.put(month.getKey(), new LinkedHashSet<String>(month.getValue()));
            }
            return treeMap;
        }
    }

    static class LicenseInfoWrapper {
        final LicenseInfo content;
        final String checksum;

        @JsonCreator
        LicenseInfoWrapper(@JsonProperty(value="content", required=true) LicenseInfo content, @JsonProperty(value="checksum", required=true) String checksum) {
            this.content = content;
            this.checksum = checksum;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class LicenseInfo {
        final String key;
        final int quota;
        final LocalDate endDate;

        @JsonCreator
        LicenseInfo(@JsonProperty(value="key", required=true) String key, @JsonProperty(value="quota", required=true) int quota, @JsonProperty(value="endDate", required=true) LocalDate endDate) {
            this.key = key;
            this.quota = quota;
            this.endDate = endDate;
        }
    }
}

