/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.collaborationengine.AbstractMapChange;
import com.vaadin.collaborationengine.CollaborationList;
import com.vaadin.collaborationengine.CollaborationMap;
import com.vaadin.collaborationengine.ConnectionContext;
import com.vaadin.collaborationengine.EventUtil;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.ListChange;
import com.vaadin.collaborationengine.ListChangeEvent;
import com.vaadin.collaborationengine.ListSubscriber;
import com.vaadin.collaborationengine.MapChange;
import com.vaadin.collaborationengine.MapChangeEvent;
import com.vaadin.collaborationengine.MapSubscriber;
import com.vaadin.collaborationengine.PutChange;
import com.vaadin.collaborationengine.ReplaceChange;
import com.vaadin.collaborationengine.Topic;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TopicConnection {
    private final Topic topic;
    private final ConnectionContext context;
    private final UserInfo localUser;
    private Registration closeRegistration;
    private final List<Registration> deactivateRegistrations = new ArrayList<Registration>();
    private final Consumer<Boolean> topicActivationHandler;
    private final Map<String, List<Topic.MapChangeNotifier>> subscribersPerMap = new HashMap<String, List<Topic.MapChangeNotifier>>();
    private final Map<String, List<Topic.ListChangeNotifier>> subscribersPerList = new HashMap<String, List<Topic.ListChangeNotifier>>();
    private boolean active;

    TopicConnection(ConnectionContext context, Topic topic, UserInfo localUser, Consumer<Boolean> topicActivationHandler, SerializableFunction<TopicConnection, Registration> connectionActivationCallback) {
        this.topic = topic;
        this.context = context;
        this.localUser = localUser;
        this.topicActivationHandler = topicActivationHandler;
        this.closeRegistration = context.setActivationHandler(active -> {
            if (active) {
                this.active = true;
                context.dispatchAction((Command & Serializable)() -> {
                    Registration listChangeRegistration;
                    Registration mapChangeRegistration;
                    Topic topic = this.topic;
                    synchronized (topic) {
                        mapChangeRegistration = this.topic.subscribeToMapChange(this::handleMapChange);
                        listChangeRegistration = this.topic.subscribeToListChange(this::handleListChange);
                    }
                    Registration callbackRegistration = (Registration)connectionActivationCallback.apply((Object)this);
                    this.addRegistration(callbackRegistration);
                    this.addRegistration((Registration & Serializable)() -> {
                        Topic topic = this.topic;
                        synchronized (topic) {
                            mapChangeRegistration.remove();
                            listChangeRegistration.remove();
                        }
                    });
                });
            } else {
                this.deactivate();
            }
            topicActivationHandler.accept(active);
        });
    }

    private void handleMapChange(MapChange change) {
        try {
            EventUtil.fireEvents(this.subscribersPerMap.get(change.getMapName()), notifier -> notifier.onEntryChange(change), false);
        }
        catch (RuntimeException e) {
            this.deactivateAndClose();
            throw e;
        }
    }

    private void handleListChange(ListChange change) {
        try {
            EventUtil.fireEvents(this.subscribersPerList.get(change.getListName()), notifier -> notifier.onListChange(change), false);
        }
        catch (RuntimeException e) {
            this.deactivateAndClose();
            throw e;
        }
    }

    Topic getTopic() {
        return this.topic;
    }

    public UserInfo getUserInfo() {
        return this.localUser;
    }

    private void addRegistration(Registration registration) {
        if (registration != null) {
            this.deactivateRegistrations.add(registration);
        }
    }

    private Registration subscribeToMap(String mapName, Topic.MapChangeNotifier mapChangeNotifier) {
        this.subscribersPerMap.computeIfAbsent(mapName, key -> new ArrayList()).add(mapChangeNotifier);
        return (Registration & Serializable)() -> this.unsubscribeFromMap(mapName, mapChangeNotifier);
    }

    private void unsubscribeFromMap(String mapName, Topic.MapChangeNotifier mapChangeNotifier) {
        List<Topic.MapChangeNotifier> notifiers = this.subscribersPerMap.get(mapName);
        if (notifiers == null) {
            return;
        }
        notifiers.remove(mapChangeNotifier);
        if (notifiers.isEmpty()) {
            this.subscribersPerMap.remove(mapName);
        }
    }

    private Registration subscribeToList(String listName, Topic.ListChangeNotifier changeNotifier) {
        this.subscribersPerList.computeIfAbsent(listName, key -> new ArrayList()).add(changeNotifier);
        return (Registration & Serializable)() -> this.unsubscribeFromList(listName, changeNotifier);
    }

    private void unsubscribeFromList(String listName, Topic.ListChangeNotifier changeNotifier) {
        List<Topic.ListChangeNotifier> notifiers = this.subscribersPerList.get(listName);
        if (notifiers == null) {
            return;
        }
        notifiers.remove(changeNotifier);
        if (notifiers.isEmpty()) {
            this.subscribersPerList.remove(listName);
        }
    }

    public CollaborationMap getNamedMap(final String name) {
        this.ensureActiveConnection();
        return new CollaborationMap(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Registration subscribe(MapSubscriber subscriber) {
                TopicConnection.this.ensureActiveConnection();
                Objects.requireNonNull(subscriber, "Subscriber cannot be null");
                Topic topic = TopicConnection.this.topic;
                synchronized (topic) {
                    Topic.MapChangeNotifier mapChangeNotifier = mapChange -> {
                        MapChangeEvent event = new MapChangeEvent(this, mapChange);
                        TopicConnection.this.context.dispatchAction((Command & Serializable)() -> subscriber.onMapChange(event));
                    };
                    TopicConnection.this.topic.getMapData(name).forEach(mapChangeNotifier::onEntryChange);
                    Registration registration = TopicConnection.this.subscribeToMap(name, mapChangeNotifier);
                    TopicConnection.this.addRegistration(registration);
                    return registration;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompletableFuture<Boolean> replace(String key, Object expectedValue, Object newValue) {
                boolean isReplaced;
                TopicConnection.this.ensureActiveConnection();
                Objects.requireNonNull(key, "Key cannot be null");
                CompletableFuture<Boolean> contextFuture = TopicConnection.this.context.createCompletableFuture();
                Topic topic = TopicConnection.this.topic;
                synchronized (topic) {
                    isReplaced = TopicConnection.this.topic.applyMapReplace(new ReplaceChange(name, key, JsonUtil.toJsonNode(expectedValue), JsonUtil.toJsonNode(newValue)));
                }
                TopicConnection.this.context.dispatchAction((Command & Serializable)() -> contextFuture.complete(isReplaced));
                return contextFuture;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompletableFuture<Void> put(String key, Object value) {
                TopicConnection.this.ensureActiveConnection();
                Objects.requireNonNull(key, "Key cannot be null");
                CompletableFuture<Void> contextFuture = TopicConnection.this.context.createCompletableFuture();
                Topic topic = TopicConnection.this.topic;
                synchronized (topic) {
                    TopicConnection.this.topic.applyMapChange(new PutChange(name, key, JsonUtil.toJsonNode(value)));
                }
                TopicConnection.this.context.dispatchAction((Command & Serializable)() -> contextFuture.complete(null));
                return contextFuture;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Stream<String> getKeys() {
                TopicConnection.this.ensureActiveConnection();
                Topic topic = TopicConnection.this.topic;
                synchronized (topic) {
                    List snapshot = TopicConnection.this.topic.getMapData(name).map(AbstractMapChange::getKey).collect(Collectors.toList());
                    return snapshot.stream();
                }
            }

            @Override
            public <T> T get(String key, Class<T> type) {
                return JsonUtil.toInstance(this.get(key), type);
            }

            @Override
            public <T> T get(String key, TypeReference<T> type) {
                return JsonUtil.toInstance(this.get(key), type);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private JsonNode get(String key) {
                TopicConnection.this.ensureActiveConnection();
                Objects.requireNonNull(key, "Key cannot be null");
                Topic topic = TopicConnection.this.topic;
                synchronized (topic) {
                    return TopicConnection.this.topic.getMapValue(name, key);
                }
            }

            @Override
            public TopicConnection getConnection() {
                return TopicConnection.this;
            }

            @Override
            public Optional<Duration> getExpirationTimeout() {
                Duration expirationTimeout = ((TopicConnection)TopicConnection.this).topic.mapExpirationTimeouts.get(name);
                return Optional.ofNullable(expirationTimeout);
            }

            @Override
            public void setExpirationTimeout(Duration expirationTimeout) {
                if (expirationTimeout == null) {
                    ((TopicConnection)TopicConnection.this).topic.mapExpirationTimeouts.remove(name);
                } else {
                    ((TopicConnection)TopicConnection.this).topic.mapExpirationTimeouts.put(name, expirationTimeout);
                }
            }
        };
    }

    public CollaborationList getNamedList(final String name) {
        this.ensureActiveConnection();
        return new CollaborationList(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Registration subscribe(ListSubscriber subscriber) {
                TopicConnection.this.ensureActiveConnection();
                Objects.requireNonNull(subscriber, "Subscriber cannot be null");
                Topic topic = TopicConnection.this.topic;
                synchronized (topic) {
                    Topic.ListChangeNotifier changeNotifier = listChange -> {
                        ListChangeEvent event = new ListChangeEvent(this, listChange);
                        TopicConnection.this.context.dispatchAction((Command & Serializable)() -> subscriber.onListChange(event));
                    };
                    TopicConnection.this.topic.getListChanges(name).forEach(changeNotifier::onListChange);
                    Registration registration = TopicConnection.this.subscribeToList(name, changeNotifier);
                    TopicConnection.this.addRegistration(registration);
                    return registration;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> List<T> getItems(Class<T> type) {
                TopicConnection.this.ensureActiveConnection();
                Objects.requireNonNull(type, "The type can't be null");
                Topic topic = TopicConnection.this.topic;
                synchronized (topic) {
                    return TopicConnection.this.topic.getListItems(name).map(node -> JsonUtil.toInstance(node, type)).collect(Collectors.toList());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> List<T> getItems(TypeReference<T> type) {
                TopicConnection.this.ensureActiveConnection();
                Objects.requireNonNull(type, "The type reference cannot be null");
                Topic topic = TopicConnection.this.topic;
                synchronized (topic) {
                    return TopicConnection.this.topic.getListItems(name).map(node -> JsonUtil.toInstance(node, type)).collect(Collectors.toList());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompletableFuture<Void> append(Object item) {
                TopicConnection.this.ensureActiveConnection();
                Objects.requireNonNull(item, "The item cannot be null");
                CompletableFuture<Void> contextFuture = TopicConnection.this.context.createCompletableFuture();
                Topic topic = TopicConnection.this.topic;
                synchronized (topic) {
                    JsonNode value = JsonUtil.toJsonNode(item);
                    TopicConnection.this.topic.applyListChange(new ListChange(name, value));
                }
                TopicConnection.this.context.dispatchAction((Command & Serializable)() -> contextFuture.complete(null));
                return contextFuture;
            }

            @Override
            public TopicConnection getConnection() {
                return TopicConnection.this;
            }

            @Override
            public Optional<Duration> getExpirationTimeout() {
                Duration expirationTimeout = ((TopicConnection)TopicConnection.this).topic.listExpirationTimeouts.get(name);
                return Optional.ofNullable(expirationTimeout);
            }

            @Override
            public void setExpirationTimeout(Duration expirationTimeout) {
                if (expirationTimeout == null) {
                    ((TopicConnection)TopicConnection.this).topic.listExpirationTimeouts.remove(name);
                } else {
                    ((TopicConnection)TopicConnection.this).topic.listExpirationTimeouts.put(name, expirationTimeout);
                }
            }
        };
    }

    private void deactivate() {
        try {
            EventUtil.fireEvents(this.deactivateRegistrations, Registration::remove, false);
            this.deactivateRegistrations.clear();
        }
        catch (RuntimeException e) {
            this.closeWithoutDeactivating();
            throw e;
        }
    }

    void deactivateAndClose() {
        try {
            this.deactivate();
        }
        finally {
            this.closeWithoutDeactivating();
        }
    }

    void closeWithoutDeactivating() {
        try {
            if (this.closeRegistration != null) {
                this.closeRegistration.remove();
                this.closeRegistration = null;
            }
        }
        finally {
            this.topicActivationHandler.accept(false);
            this.active = false;
        }
    }

    private void ensureActiveConnection() {
        if (!this.active) {
            throw new IllegalStateException("Cannot perform this operation on a deactivated connection.");
        }
    }
}

