/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.collaborationengine.CollaborationList;
import com.vaadin.collaborationengine.JsonUtil;
import com.vaadin.collaborationengine.ListChange;
import com.vaadin.collaborationengine.ListChangeType;
import com.vaadin.collaborationengine.ListKey;
import java.util.EventObject;
import java.util.Optional;
import java.util.function.Function;

public class ListChangeEvent
extends EventObject {
    private ListChange change;

    ListChangeEvent(CollaborationList list, ListChange change) {
        super(list);
        this.change = change;
    }

    @Override
    public CollaborationList getSource() {
        return (CollaborationList)super.getSource();
    }

    ListChangeType getType() {
        return this.change.getType();
    }

    public ListKey getKey() {
        return new ListKey(this.change.getKey());
    }

    public <T> T getValue(Class<T> type) {
        return JsonUtil.toInstance(this.change.getValue(), type);
    }

    public <T> T getValue(TypeReference<T> type) {
        return JsonUtil.toInstance(this.change.getValue(), type);
    }

    public <T> T getOldValue(Class<T> type) {
        return JsonUtil.toInstance(this.change.getOldValue(), type);
    }

    public <T> T getOldValue(TypeReference<T> type) {
        return JsonUtil.toInstance(this.change.getOldValue(), type);
    }

    public ListKey getAfter() {
        return ListKey.of(this.change.getAfter());
    }

    public ListKey getOldAfter() {
        return ListKey.of(this.change.getOldAfter());
    }

    public ListKey getBefore() {
        return ListKey.of(this.change.getBefore());
    }

    public ListKey getOldBefore() {
        return ListKey.of(this.change.getOldBefore());
    }

    @Deprecated
    public <T> Optional<T> getAddedItem(Class<T> type) {
        return this.convertAddedItem(JsonUtil.fromJsonConverter(type));
    }

    @Deprecated
    public <T> Optional<T> getAddedItem(TypeReference<T> type) {
        return this.convertAddedItem(JsonUtil.fromJsonConverter(type));
    }

    private <T> Optional<T> convertAddedItem(Function<JsonNode, T> converter) {
        if (this.change.getType() != ListChangeType.INSERT) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.change.getValue()).map(converter);
    }
}

