/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.collaborationengine.Topic;
import java.util.Objects;
import java.util.UUID;

class MapChange
implements Topic.ChangeDetails {
    private final String mapName;
    private final String key;
    private final JsonNode value;
    private final JsonNode oldValue;
    private final UUID expectedId;

    MapChange(String mapName, String key, JsonNode oldValue, JsonNode newValue, UUID expectedId) {
        Objects.requireNonNull(mapName, "Map name can not be null.");
        Objects.requireNonNull(key, "Key cannot be null");
        this.mapName = mapName;
        this.key = key;
        this.value = newValue;
        this.oldValue = oldValue;
        this.expectedId = expectedId;
    }

    JsonNode getOldValue() {
        return this.oldValue;
    }

    String getMapName() {
        return this.mapName;
    }

    String getKey() {
        return this.key;
    }

    JsonNode getValue() {
        return this.value;
    }

    UUID getExpectedId() {
        return this.expectedId;
    }

    boolean hasChanges() {
        return !Objects.equals(this.getOldValue(), this.getValue());
    }
}

