/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.collaborationengine;

import com.vaadin.collaborationengine.CollaborationBinder;
import com.vaadin.collaborationengine.FormManager;
import com.vaadin.collaborationengine.UserInfo;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.fieldhighlighter.FieldHighlighterInitializer;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

class FieldHighlighter
extends FieldHighlighterInitializer
implements Serializable {
    private final SerializableFunction<UserInfo, Integer> colorIndexProvider;

    static Registration setupForField(HasValue<?, ?> field, String propertyName, CollaborationBinder<?> binder) {
        ArrayList<Object> registrations = new ArrayList<Object>();
        if (field instanceof HasElement) {
            Element element = ((HasElement)field).getElement();
            registrations.add(FieldHighlighter.init((Element)element));
            registrations.add(element.addEventListener("vaadin-highlight-show", (DomEventListener & Serializable)e -> {
                JsonObject eventDetail = e.getEventData().getObject("event.detail");
                int fieldIndex = eventDetail != null ? (int)eventDetail.getNumber("fieldIndex") : 0;
                binder.addEditor(propertyName, fieldIndex);
            }).addEventData("event.detail"));
            registrations.add(element.addEventListener("vaadin-highlight-hide", (DomEventListener & Serializable)e -> binder.removeEditor(propertyName)));
            registrations.add((Registration & Serializable)() -> binder.removeEditor(propertyName));
        }
        return (Registration & Serializable)() -> registrations.forEach(Registration::remove);
    }

    FieldHighlighter(SerializableFunction<UserInfo, Integer> colorIndexProvider) {
        this.colorIndexProvider = colorIndexProvider;
    }

    void setEditors(HasValue<?, ?> field, List<FormManager.FocusedEditor> editors, UserInfo localUser) {
        if (field instanceof HasElement) {
            ((HasElement)field).getElement().executeJs("customElements.get('vaadin-field-highlighter').setUsers(this, $0)", new Serializable[]{this.serialize(editors.stream().filter(editor -> !editor.user.equals(localUser)))});
        }
    }

    void removeEditors(HasValue<?, ?> field) {
        this.setEditors(field, Collections.emptyList(), null);
    }

    void addEditor(HasValue<?, ?> field, UserInfo user, int fieldIndex) {
        if (field instanceof HasElement) {
            ((HasElement)field).getElement().executeJs("customElements.get('vaadin-field-highlighter').addUser(this, $0)", new Serializable[]{this.serialize(user, fieldIndex)});
        }
    }

    void removeEditor(HasValue<?, ?> field, UserInfo user, int fieldIndex) {
        if (field instanceof HasElement) {
            ((HasElement)field).getElement().executeJs("customElements.get('vaadin-field-highlighter').removeUser(this, $0)", new Serializable[]{this.serialize(user, fieldIndex)});
        }
    }

    private JsonArray serialize(Stream<FormManager.FocusedEditor> editors) {
        return (JsonArray)editors.map(this::serialize).collect(JsonUtils.asArray());
    }

    private JsonObject serialize(FormManager.FocusedEditor focusedEditor) {
        JsonObject editorJson = Json.createObject();
        editorJson.put("id", focusedEditor.user.getId());
        editorJson.put("name", Objects.toString(focusedEditor.user.getName(), ""));
        editorJson.put("colorIndex", (double)((Integer)this.colorIndexProvider.apply((Object)focusedEditor.user)).intValue());
        editorJson.put("fieldIndex", (double)focusedEditor.fieldIndex);
        return editorJson;
    }

    private JsonObject serialize(UserInfo user, int fieldIndex) {
        JsonObject editorJson = Json.createObject();
        editorJson.put("id", user.getId());
        editorJson.put("name", Objects.toString(user.getName(), ""));
        editorJson.put("colorIndex", (double)((Integer)this.colorIndexProvider.apply((Object)user)).intValue());
        editorJson.put("fieldIndex", (double)fieldIndex);
        return editorJson;
    }
}

