package com.vaadin.copilot;

import com.fasterxml.jackson.annotation.JsonInclude;

public class AccessRequirement {

    public enum Type {
        DENY_ALL, ANONYMOUS_ALLOWED, PERMIT_ALL, ROLES_ALLOWED;
    }

    private final Type type;
    private final String[] roles;

    public AccessRequirement(Type type) {
        this(type, null);
    }

    public AccessRequirement(Type type, String[] roles) {
        this.type = type;
        this.roles = roles;
    }

    public Type getType() {
        return type;
    }

    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String[] getRoles() {
        return roles;
    }
}
