package com.vaadin.copilot;

import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;

public class CopilotStatus {

    static final String PROPERTY_COPILOT_ENABLED = "copilot.enable";

    public static boolean isEnabled(VaadinServletContext context) {
        if (SpringBridge.isSpringAvailable()) {
            String value = SpringBridge.getPropertyValue(context, "vaadin." + PROPERTY_COPILOT_ENABLED);
            return !"false".equalsIgnoreCase(value);
        }

        // Not Spring
        return ApplicationConfiguration.get(context).getBooleanProperty(PROPERTY_COPILOT_ENABLED, true);
    }
}
