package com.vaadin.copilot.javarewriter;

import java.io.File;
import java.util.List;
import java.util.Objects;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.internal.ComponentTracker;

/** Information about a component in the source code. */
public record ComponentTypeAndSourceLocation(Class<? extends Component> type, List<Class> inheritanceChain,
        // component might be null, it is only required for data provider handling.
        Component component, File javaFile, ComponentTracker.Location createLocation,
        ComponentTracker.Location attachLocation, ComponentTypeAndSourceLocation parent,
        List<ComponentTypeAndSourceLocation> children) {
    /** Creates the entry where component is set {@code null} */
    public ComponentTypeAndSourceLocation(Class<? extends Component> type, List<Class> inheritanceChain, File javaFile,
            ComponentTracker.Location createLocation, ComponentTracker.Location attachLocation,
            ComponentTypeAndSourceLocation parent, List<ComponentTypeAndSourceLocation> children) {
        this(type, inheritanceChain, null, javaFile, createLocation, attachLocation, parent, children);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        ComponentTypeAndSourceLocation that = (ComponentTypeAndSourceLocation) o;
        return Objects.equals(javaFile, that.javaFile) && Objects.equals(type, that.type)
                && Objects.equals(parent, that.parent) && Objects.equals(createLocation, that.createLocation)
                && Objects.equals(attachLocation, that.attachLocation) && Objects.equals(children, that.children);
    }

    @Override
    public int hashCode() {
        return Objects.hash(type, javaFile, createLocation, attachLocation, parent, children);
    }
}
