package com.vaadin.copilot.userinfo;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

import com.vaadin.copilot.CopilotServerClient;

public class UserInfoServerClient extends CopilotServerClient {

    public UserInfo getUserInfo(String proKey) {
        URI uri = getQueryURI("userInfo");
        UserInfoRequest requestData = new UserInfoRequest(proKey);
        String json = writeAsJsonString(requestData);
        HttpRequest request = buildRequest(uri, json);
        try {
            HttpResponse<String> response = getHttpClient().send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                return null;
            }
            return readValue(response.body(), UserInfo.class);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        } catch (IOException e) {
            // no logging here as we don't want to bother developer that we
            // can't load his user info
        }

        return null;
    }
}
