package com.vaadin.copilot;

import java.util.Optional;

import com.vaadin.base.devserver.DebugWindowConnection;
import com.vaadin.flow.hotswap.HotswapCompleteEvent;
import com.vaadin.flow.hotswap.VaadinHotswapper;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.internal.BrowserLiveReloadAccessor;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.VaadinService;

import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;

public class HotswapListener implements VaadinHotswapper {

    @Override
    public void onHotswapComplete(HotswapCompleteEvent event) {
        VaadinService service = event.getService();
        BrowserLiveReload liveReload = BrowserLiveReloadAccessor.getLiveReloadFromService(service).orElse(null);

        if (liveReload != null) {
            JsonObject msg = Json.createObject();
            msg.put("command", Copilot.PREFIX + "java-after-update");
            JsonObject data = Json.createObject();
            JsonArray classes = Json.createArray();
            data.put("classes", classes);
            for (Class<?> cls : event.getClasses()) {
                JsonObject classInfo = Json.createObject();
                getRoutePath(service, cls).ifPresent(routePath -> classInfo.put("routePath", routePath));
                classInfo.put("class", cls.getName());
                classInfo.put("redefined", event.isRedefined());
                classes.set(classes.length(), classInfo);
            }
            msg.put("data", data);
            ((DebugWindowConnection) liveReload).broadcast(msg);
        }
    }

    private Optional<String> getRoutePath(VaadinService service, Class<?> maybeRouteClass) {
        if (maybeRouteClass.getAnnotation(Route.class) != null) {
            return Optional.ofNullable(RouteUtil.getRoutePath(service.getContext(), maybeRouteClass));
        }
        return Optional.empty();
    }
}
