package com.vaadin.copilot.analytics;

import java.util.HashMap;
import java.util.Map;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.Copilot;
import com.vaadin.copilot.CopilotCommand;

import elemental.json.JsonObject;

public class AnalyticsInterceptor implements CopilotCommand {

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("browser-info")) {
            AnalyticsClient.getInstance().setUserContext(toMap(data));
            return true;
        }
        if (command.equals("track-event")) {
            String event = Copilot.PREFIX + data.getString("event");
            JsonObject properties = data.getObject("properties");
            AnalyticsClient.getInstance().track(event, toMap(properties));
            return true;
        }
        return false;
    }

    private Map<String, String> toMap(JsonObject data) {
        if (data == null) {
            return null;
        }
        Map<String, String> map = new HashMap<>();
        for (String key : data.keys()) {
            map.put(key, data.get(key).asString());
        }
        return map;
    }

}
