/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot;

import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.Util;
import com.vaadin.copilot.ide.CopilotIDEPlugin;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSourcePathDetector {
    private JavaSourcePathDetector() {
    }

    public static PathInfo detectSourcePaths(ApplicationConfiguration applicationConfiguration) {
        return JavaSourcePathDetector.detectSourceFoldersUsingIDEPlugin().orElseGet(() -> JavaSourcePathDetector.detectSingleModuleSourceFolders(applicationConfiguration));
    }

    private static Optional<PathInfo> detectSourceFoldersUsingIDEPlugin() {
        CopilotIDEPlugin plugin = CopilotIDEPlugin.getInstance();
        if (!plugin.isActive()) {
            return Optional.empty();
        }
        try {
            JsonObject sourcePathResponse = plugin.getSourcePaths();
            ArrayList<Path> source = new ArrayList<Path>();
            source.addAll(JavaSourcePathDetector.stringArrayToPathList(sourcePathResponse, "sourcePaths"));
            source.addAll(JavaSourcePathDetector.stringArrayToPathList(sourcePathResponse, "testSourcePaths"));
            ArrayList<Path> resource = new ArrayList<Path>();
            resource.addAll(JavaSourcePathDetector.stringArrayToPathList(sourcePathResponse, "resourcePaths"));
            resource.addAll(JavaSourcePathDetector.stringArrayToPathList(sourcePathResponse, "testResourcePaths"));
            return Optional.of(JavaSourcePathDetector.filterAndFindRoot(source, resource));
        }
        catch (CopilotIDEPlugin.UnsupportedOperationByPluginException e) {
            return Optional.empty();
        }
    }

    private static PathInfo filterAndFindRoot(List<Path> sourceFolders, List<Path> resourceFolders) {
        try {
            List<Path> classpathRootFolders = JavaSourcePathDetector.getClasspathModuleRootFolders();
            if (!classpathRootFolders.isEmpty()) {
                sourceFolders = sourceFolders.stream().filter(sourceFolder -> JavaSourcePathDetector.isInAnyFolder(classpathRootFolders, sourceFolder)).toList();
                resourceFolders = resourceFolders.stream().filter(resourceFolder -> JavaSourcePathDetector.isInAnyFolder(classpathRootFolders, resourceFolder)).toList();
            }
        }
        catch (IOException | URISyntaxException e) {
            JavaSourcePathDetector.getLogger().error("Error filtering source folders using classpath", (Throwable)e);
        }
        return new PathInfo(sourceFolders, resourceFolders, JavaSourcePathDetector.getProjectRoot(sourceFolders, resourceFolders));
    }

    private static Path getProjectRoot(List<Path> sourceFolders, List<Path> resourceFolders) {
        List<Path> allPaths = Stream.concat(sourceFolders.stream(), resourceFolders.stream()).toList();
        Optional<Path> projectRoot = Util.findCommonAncestor(allPaths);
        if (projectRoot.isEmpty()) {
            throw new IllegalStateException("Unable to deduce project folder using source paths: " + String.valueOf(allPaths));
        }
        return projectRoot.get();
    }

    private static List<Path> getClasspathModuleRootFolders() throws IOException, URISyntaxException {
        return JavaSourcePathDetector.getClasspathClassesFolders().stream().map(JavaSourcePathDetector::getProjectFolderFromClasspath).filter(Objects::nonNull).toList();
    }

    private static Path getProjectFolderFromClasspath(Path classesFolder) {
        return classesFolder.endsWith(Path.of("target", "classes")) ? classesFolder.getParent().getParent() : null;
    }

    private static boolean isInAnyFolder(List<Path> folders, Path target) {
        return folders.stream().anyMatch(folder -> {
            try {
                return ProjectManager.isFileInside(target.toFile(), folder.toFile());
            }
            catch (IOException e) {
                JavaSourcePathDetector.getLogger().error("Error checking if {} is inside {}", new Object[]{target, folder, e});
                return false;
            }
        });
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(JavaSourcePathDetector.class);
    }

    private static List<Path> getClasspathClassesFolders() throws IOException, URISyntaxException {
        Enumeration<URL> resources = JavaSourcePathDetector.class.getClassLoader().getResources(".");
        ArrayList<Path> paths = new ArrayList<Path>();
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!url.getProtocol().equals("file")) continue;
            Path path = Path.of(url.toURI());
            paths.add(path);
        }
        return paths;
    }

    private static List<Path> stringArrayToPathList(JsonObject jsonObject, String key) {
        JsonArray pathsJson = jsonObject.getArray(key);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (int i = 0; i < pathsJson.length(); ++i) {
            paths.add(Path.of(pathsJson.getString(i), new String[0]));
        }
        return paths;
    }

    static PathInfo detectSingleModuleSourceFolders(ApplicationConfiguration applicationConfiguration) {
        ArrayList<Path> sourcePaths = new ArrayList<Path>();
        ArrayList<Path> resourcePaths = new ArrayList<Path>();
        Path javaSourceFolder = applicationConfiguration.getJavaSourceFolder().toPath();
        Path javaResourceFolder = applicationConfiguration.getJavaResourceFolder().toPath();
        JavaSourcePathDetector.addIfExists(sourcePaths, javaSourceFolder);
        JavaSourcePathDetector.addIfExists(resourcePaths, javaResourceFolder);
        Path kotlinSourceFolder = Util.replaceFolderInPath(javaSourceFolder, "java", "kotlin", "main");
        JavaSourcePathDetector.addIfExists(sourcePaths, kotlinSourceFolder);
        JavaSourcePathDetector.addIfExists(sourcePaths, Util.replaceFolderInPath(javaSourceFolder, "main", "test", "src"));
        JavaSourcePathDetector.addIfExists(sourcePaths, Util.replaceFolderInPath(kotlinSourceFolder, "main", "test", "src"));
        JavaSourcePathDetector.addIfExists(resourcePaths, Util.replaceFolderInPath(javaResourceFolder, "main", "test", "src"));
        return new PathInfo(sourcePaths, resourcePaths, applicationConfiguration.getProjectFolder().toPath());
    }

    private static void addIfExists(List<Path> sourcePaths, Path path) {
        if (path.toFile().exists()) {
            sourcePaths.add(path);
        }
    }

    public record PathInfo(List<Path> sourceFolders, List<Path> resourceFolders, Path projectRoot) {
    }
}

