/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.accessibilitychecker;

import com.vaadin.base.devserver.DevToolsInterface;
import com.vaadin.copilot.CopilotCommand;
import com.vaadin.copilot.ProjectManager;
import com.vaadin.copilot.plugins.accessibilitychecker.AccessibilityJavaSourceModifier;
import elemental.json.Json;
import elemental.json.JsonObject;

public class AccessibilityCheckerMessageHandler
implements CopilotCommand {
    public static final String ACCESSIBILITY_CHECKER = "a11y-checker";
    public static final String UI_ID = "uiId";
    private final AccessibilityJavaSourceModifier accessibilityJavaSourceModifier;

    public AccessibilityCheckerMessageHandler(ProjectManager projectManager) {
        this.accessibilityJavaSourceModifier = new AccessibilityJavaSourceModifier(projectManager, (devToolsInterface, errorMessage) -> {
            JsonObject object = Json.createObject();
            object.put("message", errorMessage);
            devToolsInterface.send("a11y-checker-error", object);
        }, devToolsInterface -> {
            JsonObject object = Json.createObject();
            devToolsInterface.send("a11y-checker-success", object);
        });
    }

    @Override
    public boolean handleMessage(String command, JsonObject data, DevToolsInterface devToolsInterface) {
        if (command.equals("a11y-checker-update-page-title")) {
            int uiId = (int)data.getNumber(UI_ID);
            String label = data.getString("label");
            this.accessibilityJavaSourceModifier.setPageTitle(devToolsInterface, uiId, label);
            return true;
        }
        return false;
    }
}

