import type { LoginI18n } from '@vaadin/react-components/LoginOverlay.js';
import { LoginOverlay, LoginOverlayElement } from '@vaadin/react-components/LoginOverlay.js';
import { useAuth } from 'Frontend/util/auth.js';
import { useState } from 'react';
import { useNavigate } from 'react-router';
import { ViewConfig } from '@vaadin/hilla-file-router/types.js';

const loginI18n: LoginI18n = {
  ...new LoginOverlayElement().i18n,
  header: { title: 'TITLE_FOR_SINGLE_QUOTED_STRING', description: 'DESCRIPTION_FOR_SINGLE_QUOTED_STRING' },
};

export const config: ViewConfig = {
  menu: { exclude: true },
};

export default function LoginView() {
  const { login } = useAuth();
  const [hasError, setError] = useState<boolean>();
  const navigate = useNavigate();

  return (
    <LoginOverlay
      opened
      error={hasError}
      noForgotPassword
      i18n={loginI18n}
      onLogin={async ({ detail: { username, password } }) => {
        const { defaultUrl, error, redirectUrl } = await login(username, password);

        if (error) {
          setError(true);
        } else {
          const url = redirectUrl ?? defaultUrl ?? '/';
          const path = new URL(url, document.baseURI).pathname;
          navigate(path);
        }
      }}
    />
  );
}
