/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.converter;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;

public class LocalDateToDateConverter
implements Converter<LocalDate, Date> {
    private ZoneId zoneId;

    public LocalDateToDateConverter(ZoneId zoneId) {
        this.zoneId = Objects.requireNonNull(zoneId, "Zone id cannot be null");
    }

    public LocalDateToDateConverter() {
        this(ZoneId.systemDefault());
    }

    @Override
    public Result<Date> convertToModel(LocalDate localDate, ValueContext context) {
        if (localDate == null) {
            return Result.ok(null);
        }
        return Result.ok(Date.from(localDate.atStartOfDay(this.zoneId).toInstant()));
    }

    @Override
    public LocalDate convertToPresentation(Date date, ValueContext context) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(this.zoneId).toLocalDate();
    }
}

