/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.DataChangeEvent;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractDataProvider<T, F>
implements DataProvider<T, F> {
    private HashMap<Class<?>, List<DataListenerWrapper>> listeners = new HashMap();

    @Override
    public Registration addDataProviderListener(final DataProviderListener<T> listener) {
        SerializableConsumer<DataChangeEvent> consumer = new SerializableConsumer<DataChangeEvent>(){

            public void accept(DataChangeEvent dataChangeEvent) {
                listener.onDataChange(dataChangeEvent);
            }
        };
        return this.addListener(DataChangeEvent.class, consumer);
    }

    @Override
    public void refreshAll() {
        this.fireEvent(new DataChangeEvent(this));
    }

    @Override
    public void refreshItem(T item, boolean refreshChildren) {
        this.fireEvent(new DataChangeEvent.DataRefreshEvent<T>(this, item, refreshChildren));
    }

    @Override
    public void refreshItem(T item) {
        this.fireEvent(new DataChangeEvent.DataRefreshEvent<T>(this, item));
    }

    protected <E> Registration addListener(Class<E> eventType, SerializableConsumer<E> method) {
        List list = this.listeners.computeIfAbsent(eventType, key -> new ArrayList());
        DataListenerWrapper wrapper = new DataListenerWrapper(method);
        wrapper.registration = Registration.addAndRemove((Collection)list, (Object)wrapper);
        return wrapper.registration;
    }

    protected void fireEvent(EventObject event) {
        this.listeners.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(event.getClass())).forEach(entry -> new ArrayList<DataListenerWrapper>((Collection)entry.getValue()).forEach(wrapper -> this.fireEventForListener(event, (DataListenerWrapper)wrapper)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventForListener(EventObject event, DataListenerWrapper wrapper) {
        if (event instanceof DataChangeEvent) {
            DataChangeEvent dataEvent = (DataChangeEvent)event;
            dataEvent.setUnregisterListenerCommand(() -> ((Registration)wrapper.registration).remove());
            SerializableConsumer<?> consumer = wrapper.listener;
            try {
                consumer.accept((EventObject)event);
            }
            finally {
                dataEvent.setUnregisterListenerCommand(null);
            }
        }
    }

    private static class DataListenerWrapper
    implements Serializable {
        private final SerializableConsumer<?> listener;
        private Registration registration;

        public DataListenerWrapper(SerializableConsumer<?> listener) {
            this.listener = listener;
        }
    }
}

