/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.QuerySortOrder;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class Query<T, F>
implements Serializable {
    private final int offset;
    private final int limit;
    private final List<QuerySortOrder> sortOrders;
    private final Comparator<T> inMemorySorting;
    private final F filter;

    public Query() {
        this.offset = 0;
        this.limit = Integer.MAX_VALUE;
        this.sortOrders = Collections.emptyList();
        this.inMemorySorting = null;
        this.filter = null;
    }

    public Query(F filter) {
        this.offset = 0;
        this.limit = Integer.MAX_VALUE;
        this.sortOrders = Collections.emptyList();
        this.inMemorySorting = null;
        this.filter = filter;
    }

    public Query(int offset, int limit, List<QuerySortOrder> sortOrders, Comparator<T> inMemorySorting, F filter) {
        this.offset = offset;
        this.limit = limit;
        this.sortOrders = sortOrders;
        this.inMemorySorting = inMemorySorting;
        this.filter = filter;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getPage() {
        return this.getOffset() / this.getLimit();
    }

    public int getPageSize() {
        return this.getLimit();
    }

    public List<QuerySortOrder> getSortOrders() {
        return this.sortOrders;
    }

    public Optional<F> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    public Comparator<T> getInMemorySorting() {
        return this.inMemorySorting;
    }

    public Optional<Comparator<T>> getSortingComparator() {
        return Optional.ofNullable(this.inMemorySorting);
    }

    public int getRequestedRangeEnd() {
        return this.getOffset() + this.getLimit();
    }
}

