/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.binder;

import com.vaadin.flow.data.binder.SimpleResult;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public interface Result<R>
extends Serializable {
    public static <R> Result<R> ok(R value) {
        return new SimpleResult<R>(value, null);
    }

    public static <R> Result<R> error(String message) {
        Objects.requireNonNull(message, "message cannot be null");
        return new SimpleResult<Object>(null, message);
    }

    public static <R> Result<R> of(SerializableSupplier<R> supplier, SerializableFunction<Exception, String> onError) {
        Objects.requireNonNull(supplier, "supplier cannot be null");
        Objects.requireNonNull(onError, "onError cannot be null");
        try {
            return Result.ok(supplier.get());
        }
        catch (Exception e) {
            return Result.error((String)onError.apply((Object)e));
        }
    }

    default public <S> Result<S> map(SerializableFunction<R, S> mapper) {
        return this.flatMap((SerializableFunction & Serializable)value -> Result.ok(mapper.apply(value)));
    }

    public <S> Result<S> flatMap(SerializableFunction<R, Result<S>> var1);

    public void handle(SerializableConsumer<R> var1, SerializableConsumer<String> var2);

    default public void ifOk(SerializableConsumer<R> consumer) {
        this.handle(consumer, (SerializableConsumer<String>)(SerializableConsumer & Serializable)error -> {});
    }

    default public void ifError(SerializableConsumer<String> consumer) {
        this.handle((SerializableConsumer & Serializable)value -> {}, consumer);
    }

    public boolean isError();

    public Optional<String> getMessage();

    public <X extends Throwable> R getOrThrow(SerializableFunction<String, ? extends X> var1) throws X;
}

