/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.InMemoryDataProviderHelpers;
import com.vaadin.flow.data.provider.SortDirection;
import com.vaadin.flow.function.SerializableBiPredicate;
import com.vaadin.flow.function.SerializableComparator;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public interface InMemoryDataProvider<T>
extends ConfigurableFilterDataProvider<T, SerializablePredicate<T>, SerializablePredicate<T>> {
    @Override
    default public boolean isInMemory() {
        return true;
    }

    public SerializablePredicate<T> getFilter();

    @Override
    public void setFilter(SerializablePredicate<T> var1);

    default public <V> void setFilter(ValueProvider<T, V> valueProvider, SerializablePredicate<V> valueFilter) {
        this.setFilter(InMemoryDataProviderHelpers.createValueProviderFilter(valueProvider, valueFilter));
    }

    default public void addFilter(SerializablePredicate<T> filter) {
        Objects.requireNonNull(filter, "Filter cannot be null");
        if (this.getFilter() == null) {
            this.setFilter(filter);
        } else {
            SerializablePredicate oldFilter = this.getFilter();
            this.setFilter((SerializablePredicate<T>)(SerializablePredicate & Serializable)item -> oldFilter.test(item) && filter.test(item));
        }
    }

    default public <V> void addFilter(ValueProvider<T, V> valueProvider, SerializablePredicate<V> valueFilter) {
        Objects.requireNonNull(valueProvider, "Value provider cannot be null");
        Objects.requireNonNull(valueFilter, "Value filter cannot be null");
        this.addFilter(InMemoryDataProviderHelpers.createValueProviderFilter(valueProvider, valueFilter));
    }

    default public <V> void setFilterByValue(ValueProvider<T, V> valueProvider, V requiredValue) {
        this.setFilter(InMemoryDataProviderHelpers.createEqualsFilter(valueProvider, requiredValue));
    }

    default public <V> void addFilterByValue(ValueProvider<T, V> valueProvider, V requiredValue) {
        this.addFilter(InMemoryDataProviderHelpers.createEqualsFilter(valueProvider, requiredValue));
    }

    default public void clearFilters() {
        this.setFilter(null);
    }

    public SerializableComparator<T> getSortComparator();

    public void setSortComparator(SerializableComparator<T> var1);

    default public void addSortComparator(SerializableComparator<T> comparator) {
        Objects.requireNonNull(comparator, "Comparator to add cannot be null");
        SerializableComparator originalComparator = this.getSortComparator();
        if (originalComparator == null) {
            this.setSortComparator(comparator);
        } else {
            this.setSortComparator((SerializableComparator & Serializable)(a, b) -> {
                int result = originalComparator.compare(a, b);
                if (result == 0) {
                    result = comparator.compare(a, b);
                }
                return result;
            });
        }
    }

    default public <V extends Comparable<? super V>> void setSortOrder(ValueProvider<T, V> valueProvider, SortDirection sortDirection) {
        this.setSortComparator(InMemoryDataProviderHelpers.propertyComparator(valueProvider, sortDirection));
    }

    default public <V extends Comparable<? super V>> void addSortOrder(ValueProvider<T, V> valueProvider, SortDirection sortDirection) {
        this.addSortComparator(InMemoryDataProviderHelpers.propertyComparator(valueProvider, sortDirection));
    }

    default public <Q> DataProvider<T, Q> filteringBy(SerializableBiPredicate<T, Q> predicate) {
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        return this.withConvertedFilter((SerializableFunction & Serializable)filterValue -> (SerializablePredicate & Serializable)item -> predicate.test(item, filterValue));
    }

    default public <V, Q> DataProvider<T, Q> filteringBy(ValueProvider<T, V> valueProvider, SerializableBiPredicate<V, Q> predicate) {
        Objects.requireNonNull(valueProvider, "Value provider cannot be null");
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        return this.filteringBy((SerializableBiPredicate & Serializable)(item, filterValue) -> predicate.test(valueProvider.apply(item), filterValue));
    }

    default public <V> DataProvider<T, V> filteringByEquals(ValueProvider<T, V> valueProvider) {
        return this.filteringBy(valueProvider, Objects::equals);
    }

    default public DataProvider<T, String> filteringBySubstring(ValueProvider<T, String> valueProvider, Locale locale) {
        Objects.requireNonNull(locale, "Locale cannot be null");
        return InMemoryDataProviderHelpers.filteringByCaseInsensitiveString(this, valueProvider, (SerializableBiPredicate<String, String>)((SerializableBiPredicate & Serializable)String::contains), (SerializableSupplier<Locale>)(SerializableSupplier & Serializable)() -> locale);
    }

    default public DataProvider<T, String> filteringBySubstring(ValueProvider<T, String> valueProvider) {
        return InMemoryDataProviderHelpers.filteringByCaseInsensitiveString(this, valueProvider, (SerializableBiPredicate<String, String>)((SerializableBiPredicate & Serializable)String::contains), InMemoryDataProviderHelpers.CURRENT_LOCALE_SUPPLIER);
    }

    default public DataProvider<T, String> filteringByPrefix(ValueProvider<T, String> valueProvider, Locale locale) {
        return InMemoryDataProviderHelpers.filteringByCaseInsensitiveString(this, valueProvider, (SerializableBiPredicate<String, String>)((SerializableBiPredicate & Serializable)String::startsWith), (SerializableSupplier<Locale>)(SerializableSupplier & Serializable)() -> locale);
    }

    default public DataProvider<T, String> filteringByPrefix(ValueProvider<T, String> valueProvider) {
        return InMemoryDataProviderHelpers.filteringByCaseInsensitiveString(this, valueProvider, (SerializableBiPredicate<String, String>)((SerializableBiPredicate & Serializable)String::startsWith), InMemoryDataProviderHelpers.CURRENT_LOCALE_SUPPLIER);
    }
}

