/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.selection;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.data.selection.SelectionEvent;
import com.vaadin.flow.data.selection.SingleSelect;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public class SingleSelectionEvent<C extends Component, T>
extends AbstractField.ComponentValueChangeEvent<C, T>
implements SelectionEvent<C, T> {
    public SingleSelectionEvent(C listing, SingleSelect<C, T> source, T oldSelection, boolean userOriginated) {
        super(listing, source, oldSelection, userOriginated);
    }

    public Optional<T> getSelectedItem() {
        return Optional.ofNullable(this.getValue());
    }

    @Override
    public C getSource() {
        return (C)super.getSource();
    }

    @Override
    public Optional<T> getFirstSelectedItem() {
        return this.getSelectedItem();
    }

    @Override
    public Set<T> getAllSelectedItems() {
        Optional<T> selectedItem = this.getSelectedItem();
        if (selectedItem.isPresent()) {
            return Collections.singleton(selectedItem.get());
        }
        return Collections.emptySet();
    }
}

