/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.value;

import com.vaadin.flow.dom.DomListenerRegistration;

public enum ValueChangeMode {
    EAGER,
    LAZY,
    TIMEOUT,
    ON_BLUR,
    ON_CHANGE;


    public static String eventForMode(ValueChangeMode mode, String immediateEventName) {
        if (mode == null) {
            return null;
        }
        switch (mode) {
            case EAGER: 
            case LAZY: 
            case TIMEOUT: {
                return immediateEventName;
            }
            case ON_BLUR: {
                return "blur";
            }
            case ON_CHANGE: {
                return "change";
            }
        }
        ValueChangeMode.throwModeNotSupported(mode);
        return null;
    }

    public static void applyChangeTimeout(ValueChangeMode mode, int timeout, DomListenerRegistration registration) {
        if (mode == null || registration == null) {
            return;
        }
        switch (mode) {
            case LAZY: {
                registration.debounce(timeout);
                break;
            }
            case TIMEOUT: {
                registration.throttle(timeout);
                break;
            }
            case EAGER: 
            case ON_BLUR: 
            case ON_CHANGE: {
                break;
            }
            default: {
                ValueChangeMode.throwModeNotSupported(mode);
            }
        }
    }

    private static void throwModeNotSupported(ValueChangeMode mode) {
        throw new IllegalArgumentException("Value change mode " + mode.name() + " not supported");
    }
}

