/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.JarContentsManager;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import java.io.File;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCopyFrontendFiles
implements FallibleCommand {
    private static final String[] WILDCARD_INCLUSIONS = new String[]{"**/*.js", "**/*.css"};
    private File targetDirectory;
    private Set<File> resourceLocations = null;

    TaskCopyFrontendFiles(File npmFolder, Set<File> resourcesToScan) {
        Objects.requireNonNull(npmFolder, "Parameter 'npmFolder' must not be null");
        Objects.requireNonNull(resourcesToScan, "Parameter 'jarFilesToScan' must not be null");
        this.targetDirectory = new File(npmFolder, "node_modules/@vaadin/flow-frontend/");
        this.resourceLocations = resourcesToScan.stream().filter(File::exists).collect(Collectors.toSet());
    }

    @Override
    public void execute() {
        long start = System.nanoTime();
        TaskCopyFrontendFiles.log().info("Copying frontend resources from jar files ...");
        TaskCopyLocalFrontendFiles.createTargetFolder(this.targetDirectory);
        JarContentsManager jarContentsManager = new JarContentsManager();
        for (File location : this.resourceLocations) {
            if (location.isDirectory()) {
                TaskCopyLocalFrontendFiles.copyLocalResources(new File(location, "META-INF/frontend"), this.targetDirectory);
                TaskCopyLocalFrontendFiles.copyLocalResources(new File(location, "META-INF/resources/frontend"), this.targetDirectory);
                continue;
            }
            jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(location, "META-INF/frontend", this.targetDirectory, WILDCARD_INCLUSIONS);
            jarContentsManager.copyIncludedFilesFromJarTrimmingBasePath(location, "META-INF/resources/frontend", this.targetDirectory, WILDCARD_INCLUSIONS);
        }
        long ms = (System.nanoTime() - start) / 1000000L;
        TaskCopyFrontendFiles.log().info("Visited {} resources. Took {} ms.", (Object)this.resourceLocations.size(), (Object)ms);
    }

    private static Logger log() {
        return LoggerFactory.getLogger((String)"dev-updater");
    }
}

