/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.BuildUtil;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeUpdater;
import com.vaadin.flow.server.frontend.VersionsJsonConverter;
import com.vaadin.flow.server.frontend.VersionsJsonFilter;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.shared.util.SharedUtil;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class TaskRunNpmInstall
implements FallibleCommand {
    private static final String DEV_DEPENDENCIES_PATH = "dev.dependencies.path";
    private static final String MODULES_YAML = ".modules.yaml";
    private static final String INSTALL_HASH = ".vaadin/vaadin.json";
    private final NodeUpdater packageUpdater;
    private final List<String> ignoredNodeFolders = Arrays.asList(".bin", "pnpm", ".ignored_pnpm", ".pnpm", ".staging", ".vaadin", ".modules.yaml");
    private final boolean enablePnpm;
    private final boolean requireHomeNodeExec;
    private final ClassFinder classFinder;
    private final String nodeVersion;
    private final URI nodeDownloadRoot;

    TaskRunNpmInstall(ClassFinder classFinder, NodeUpdater packageUpdater, boolean enablePnpm, boolean requireHomeNodeExec, String nodeVersion, URI nodeDownloadRoot) {
        this.classFinder = classFinder;
        this.packageUpdater = packageUpdater;
        this.enablePnpm = enablePnpm;
        this.requireHomeNodeExec = requireHomeNodeExec;
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
    }

    @Override
    public void execute() throws ExecutionFailedException {
        String toolName;
        String string = toolName = this.enablePnpm ? "pnpm" : "npm";
        if (this.packageUpdater.modified || this.shouldRunNpmInstall()) {
            this.packageUpdater.log().info("Running `" + toolName + " install` to resolve and optionally download frontend dependencies. This may take a moment, please stand by...");
            this.runNpmInstall();
            this.updateLocalHash();
        } else {
            this.packageUpdater.log().info("Skipping `{} install` because the frontend packages are already installed in the folder '{}' and the hash in the file '{}' is the same as in '{}'", new Object[]{toolName, this.packageUpdater.nodeModulesFolder.getAbsolutePath(), this.getLocalHashFile().getAbsolutePath(), "package.json"});
        }
    }

    private void updateLocalHash() {
        try {
            JsonObject vaadin = this.packageUpdater.getPackageJson().getObject("vaadin");
            if (vaadin == null) {
                this.packageUpdater.log().warn("No vaadin object in package.json");
                return;
            }
            String hash = vaadin.getString("hash");
            JsonObject localHash = Json.createObject();
            localHash.put("hash", hash);
            File localHashFile = this.getLocalHashFile();
            FileUtils.forceMkdirParent((File)localHashFile);
            String content = JsonUtil.stringify((JsonValue)localHash, (int)2) + "\n";
            FileUtils.writeStringToFile((File)localHashFile, (String)content, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            this.packageUpdater.log().warn("Failed to update node_modules hash.", (Throwable)e);
        }
    }

    private File getLocalHashFile() {
        return new File(this.packageUpdater.nodeModulesFolder, INSTALL_HASH);
    }

    protected String generateVersionsJson() throws IOException {
        URL resource = this.classFinder.getResource("vaadin_versions.json");
        if (resource == null) {
            this.packageUpdater.log().warn("Couldn't find {} file to pin dependency versions. Transitive dependencies won't be pinned for pnpm.", (Object)"vaadin_versions.json");
        }
        try (InputStream content = resource == null ? null : resource.openStream();){
            File versions = new File(this.packageUpdater.generatedFolder, "versions.json");
            JsonObject versionsJson = this.getVersions(content);
            if (versionsJson == null) {
                versionsJson = this.generateVersionsFromPackageJson();
            }
            FileUtils.write((File)versions, (CharSequence)(JsonUtil.stringify((JsonValue)versionsJson, (int)2) + "\n"), (Charset)StandardCharsets.UTF_8);
            Path versionsPath = versions.toPath();
            if (versions.isAbsolute()) {
                String string = FrontendUtils.getUnixRelativePath(this.packageUpdater.npmFolder.toPath(), versionsPath);
                return string;
            }
            String string = FrontendUtils.getUnixPath(versionsPath);
            return string;
        }
    }

    private JsonObject generateVersionsFromPackageJson() throws IOException {
        JsonObject versionsJson = Json.createObject();
        JsonObject packageJson = this.packageUpdater.getPackageJson();
        JsonObject dependencies = packageJson.getObject("dependencies");
        JsonObject devDependencies = packageJson.getObject("devDependencies");
        if (dependencies != null) {
            for (String key : dependencies.keys()) {
                versionsJson.put(key, dependencies.getString(key));
            }
        }
        if (devDependencies != null) {
            for (String key : devDependencies.keys()) {
                versionsJson.put(key, devDependencies.getString(key));
            }
        }
        return versionsJson;
    }

    protected String getDevDependenciesFilePath() {
        return BuildUtil.getBuildProperty(DEV_DEPENDENCIES_PATH);
    }

    private JsonObject getVersions(InputStream platformVersions) throws IOException {
        String genDevDependenciesPath;
        JsonObject versionsJson = null;
        if (platformVersions != null) {
            VersionsJsonConverter convert = new VersionsJsonConverter(Json.parse((String)IOUtils.toString((InputStream)platformVersions, (Charset)StandardCharsets.UTF_8)));
            versionsJson = convert.getConvertedJson();
            versionsJson = new VersionsJsonFilter(this.packageUpdater.getPackageJson(), "dependencies").getFilteredVersions(versionsJson);
        }
        if ((genDevDependenciesPath = this.getDevDependenciesFilePath()) == null) {
            this.packageUpdater.log().debug("Couldn't find dev dependencies file path from proeprties file. Dev dependencies won't be locked");
            return versionsJson;
        }
        JsonObject devDeps = this.readGeneratedDevDependencies(genDevDependenciesPath);
        if (devDeps == null) {
            return versionsJson;
        }
        devDeps = new VersionsJsonFilter(this.packageUpdater.getPackageJson(), "devDependencies").getFilteredVersions(devDeps);
        if (versionsJson == null) {
            return devDeps;
        }
        for (String key : versionsJson.keys()) {
            devDeps.put(key, versionsJson.getString(key));
        }
        return devDeps;
    }

    private JsonObject readGeneratedDevDependencies(String path) throws IOException {
        URL resource = this.classFinder.getResource(path);
        if (resource == null) {
            this.packageUpdater.log().debug("Couldn't find  dev dependencies file. Dev dependencies won't be locked");
            return null;
        }
        try (InputStream content = resource.openStream();){
            JsonObject jsonObject = Json.parse((String)IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8));
            return jsonObject;
        }
    }

    private boolean shouldRunNpmInstall() {
        if (this.packageUpdater.nodeModulesFolder.isDirectory()) {
            File[] installedPackages = this.packageUpdater.nodeModulesFolder.listFiles((dir, name) -> !this.ignoredNodeFolders.contains(name));
            assert (installedPackages != null);
            return installedPackages.length == 0 || installedPackages.length == 1 && "@vaadin/flow-frontend/".startsWith(installedPackages[0].getName()) || installedPackages.length > 0 && this.isVaadinHashUpdated();
        }
        return true;
    }

    private boolean isVaadinHashUpdated() {
        File localHashFile = this.getLocalHashFile();
        if (localHashFile.exists()) {
            try {
                String fileContent = FileUtils.readFileToString((File)localHashFile, (String)StandardCharsets.UTF_8.name());
                JsonObject content = Json.parse((String)fileContent);
                if (content.hasKey("hash")) {
                    JsonObject packageJson = this.packageUpdater.getPackageJson();
                    return !content.getString("hash").equals(packageJson.getObject("vaadin").getString("hash"));
                }
            }
            catch (IOException e) {
                this.packageUpdater.log().warn("Failed to load hashes forcing npm execution", (Throwable)e);
            }
        }
        return true;
    }

    private void runNpmInstall() throws ExecutionFailedException {
        List<String> executable;
        try {
            this.cleanUp();
        }
        catch (IOException exception) {
            throw new ExecutionFailedException("Couldn't remove " + this.packageUpdater.nodeModulesFolder + " directory", exception);
        }
        if (this.enablePnpm) {
            try {
                this.createPnpmFile(this.generateVersionsJson());
            }
            catch (IOException exception) {
                throw new ExecutionFailedException("Failed to read frontend version data from vaadin-core and make it available to pnpm for locking transitive dependencies.\nPlease report an issue, as a workaround try running project with npm by setting system variable -Dvaadin.pnpm.enable=false", exception);
            }
        }
        String baseDir = this.packageUpdater.npmFolder.getAbsolutePath();
        FrontendTools tools = new FrontendTools(baseDir, () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath(), this.nodeVersion, this.nodeDownloadRoot);
        try {
            if (this.requireHomeNodeExec) {
                tools.forceAlternativeNodeExecutable();
            }
            executable = this.enablePnpm ? tools.getPnpmExecutable() : tools.getNpmExecutable();
        }
        catch (IllegalStateException exception) {
            throw new ExecutionFailedException(exception.getMessage(), exception);
        }
        ArrayList<String> command = new ArrayList<String>(executable);
        command.add("install");
        if (this.packageUpdater.log().isDebugEnabled()) {
            this.packageUpdater.log().debug(FrontendUtils.commandToString(this.packageUpdater.npmFolder.getAbsolutePath(), command));
        }
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("ADBLOCK", "1");
        builder.environment().put("NO_UPDATE_NOTIFIER", "1");
        builder.directory(this.packageUpdater.npmFolder);
        builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        String toolName = this.enablePnpm ? "pnpm" : "npm";
        String commandString = command.stream().collect(Collectors.joining(" "));
        Process process = null;
        try {
            Process finalProcess = process = builder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(finalProcess::destroyForcibly));
            this.packageUpdater.log().debug("Output of `{}`:", (Object)commandString);
            StringBuilder toolOutput = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    this.packageUpdater.log().debug(stdoutLine);
                    toolOutput.append(stdoutLine);
                }
            }
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                this.packageUpdater.log().error("Command `{}` failed:\n{}", (Object)commandString, (Object)toolOutput);
                this.packageUpdater.log().error(">>> Dependency ERROR. Check that all required dependencies are deployed in {} repositories.", (Object)toolName);
                throw new ExecutionFailedException(SharedUtil.capitalize(toolName) + " install has exited with non zero status. Some dependencies are not installed. Check " + toolName + " command output");
            }
            this.packageUpdater.log().info("Frontend dependencies resolved successfully.");
        }
        catch (IOException | InterruptedException e) {
            this.packageUpdater.log().error("Error when running `{} install`", (Object)toolName, (Object)e);
            throw new ExecutionFailedException("Command '" + toolName + " install' failed to finish", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    private void createPnpmFile(String versionsPath) throws IOException {
        if (versionsPath == null) {
            return;
        }
        File pnpmFile = new File(this.packageUpdater.npmFolder.getAbsolutePath(), "pnpmfile.js");
        try (InputStream content = TaskRunNpmInstall.class.getResourceAsStream("/pnpmfile.js");){
            if (content == null) {
                throw new IOException("Couldn't find template pnpmfile.js in the classpath");
            }
            FileUtils.copyInputStreamToFile((InputStream)content, (File)pnpmFile);
            this.packageUpdater.log().info("Generated pnpmfile hook file: '{}'", (Object)pnpmFile);
            FileUtils.writeLines((File)pnpmFile, this.modifyPnpmFile(pnpmFile, versionsPath));
        }
    }

    private List<String> modifyPnpmFile(File generatedFile, String versionsPath) throws IOException {
        List lines = FileUtils.readLines((File)generatedFile, (Charset)StandardCharsets.UTF_8);
        int i = 0;
        for (String line : lines) {
            if (line.startsWith("const versionsFile")) {
                lines.set(i, "const versionsFile = require('path').resolve(__dirname, '" + versionsPath + "');");
            }
            ++i;
        }
        return lines;
    }

    private void cleanUp() throws IOException {
        File staging;
        boolean hasModulesYaml;
        if (!this.packageUpdater.nodeModulesFolder.exists()) {
            return;
        }
        File modulesYaml = new File(this.packageUpdater.nodeModulesFolder, MODULES_YAML);
        boolean bl = hasModulesYaml = modulesYaml.exists() && modulesYaml.isFile();
        if (!this.enablePnpm && hasModulesYaml) {
            FileUtils.forceDelete((File)this.packageUpdater.nodeModulesFolder);
        } else if (!(!this.enablePnpm || hasModulesYaml || (staging = new File(this.packageUpdater.nodeModulesFolder, ".staging")).isDirectory() && staging.listFiles((dir, name) -> name.startsWith("pnpm-")).length != 0)) {
            FileUtils.forceDelete((File)this.packageUpdater.nodeModulesFolder);
        }
    }
}

