/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.impl.CustomAttribute;
import java.util.Arrays;
import java.util.stream.Collectors;

public class ClassAttributeHandler
extends CustomAttribute {
    @Override
    public boolean hasAttribute(Element element) {
        return !element.getClassList().isEmpty();
    }

    @Override
    public String getAttribute(Element element) {
        ClassList classList = element.getClassList();
        if (classList.isEmpty()) {
            return null;
        }
        return classList.stream().collect(Collectors.joining(" "));
    }

    @Override
    public void setAttribute(Element element, String value) {
        ClassList classList = element.getClassList();
        classList.clear();
        if (value.isEmpty()) {
            return;
        }
        String[] parts = value.split("\\s+");
        classList.addAll(Arrays.asList(parts));
    }

    @Override
    public void removeAttribute(Element element) {
        element.getClassList().clear();
    }
}

