/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.flow.router.RouteParameterFormatOption;
import com.vaadin.flow.router.RouteParameters;
import com.vaadin.flow.router.internal.NavigationRouteTarget;
import com.vaadin.flow.router.internal.RouteFormat;
import com.vaadin.flow.router.internal.RouteSegment;
import com.vaadin.flow.router.internal.RouteTarget;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

class RouteModel
implements Serializable {
    private boolean mutable;
    private RouteSegment root;

    private RouteModel(boolean mutable) {
        this(RouteSegment.createRoot(), mutable);
    }

    private RouteModel(RouteSegment root, boolean mutable) {
        this.root = root;
        this.mutable = mutable;
    }

    static RouteModel create(boolean mutable) {
        return new RouteModel(mutable);
    }

    static RouteModel copy(RouteModel original, boolean mutable) {
        return new RouteModel(new RouteSegment(original.root), mutable);
    }

    Map<String, RouteTarget> getRoutes() {
        return this.root.getRoutes();
    }

    boolean isEmpty() {
        return this.root.isEmpty();
    }

    void clear() {
        this.throwIfImmutable();
        this.root = RouteSegment.createRoot();
    }

    void removeRoute(String template) {
        this.throwIfImmutable();
        this.root.removeSubRoute(template);
    }

    void addRoute(String template, RouteTarget target) {
        this.throwIfImmutable();
        this.root.addSubRoute(template, target);
    }

    NavigationRouteTarget getNavigationRouteTarget(String url) {
        return this.root.getNavigationRouteTarget(url);
    }

    RouteTarget getRouteTarget(String template, RouteParameters parameters) {
        AtomicReference target = new AtomicReference();
        this.root.matchSegmentTemplatesWithParameters(template, parameters, null, routeSegment -> target.set(routeSegment.getTarget()));
        return (RouteTarget)target.get();
    }

    String getUrl(String template, RouteParameters parameters) {
        ArrayList result = new ArrayList();
        this.root.matchSegmentTemplatesWithParameters(template, parameters, routeSegmentValue -> routeSegmentValue.value.ifPresent(result::add), null);
        if (result.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"/", result);
    }

    String formatTemplate(String template, Set<RouteParameterFormatOption> format) {
        if (format.contains((Object)RouteParameterFormatOption.NAME) && format.contains((Object)RouteParameterFormatOption.MODIFIER) && format.contains((Object)RouteParameterFormatOption.REGEX)) {
            return template;
        }
        return this.root.formatTemplate(template, (RouteSegment segment) -> RouteFormat.formatSegment(segment, format));
    }

    Map<String, RouteParameterData> getParameters(String template) {
        HashMap<String, RouteParameterData> result = new HashMap<String, RouteParameterData>();
        this.root.matchSegmentTemplates(template, segment -> {
            if (segment.isParameter()) {
                result.put(segment.getName(), new RouteParameterData(segment.getTemplate(), segment.getRegex().orElse(null)));
            }
        }, null);
        return result;
    }

    private void throwIfImmutable() {
        if (!this.mutable) {
            throw new IllegalStateException("Tried to mutate immutable model.");
        }
    }
}

