/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.osgi;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import com.vaadin.flow.server.startup.DevModeInitializer;
import com.vaadin.flow.server.startup.LookupServletContainerInitializer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public final class OSGiAccess {
    private static final OSGiAccess INSTANCE = new OSGiAccess();
    private final ServletContext context = LazyOSGiDetector.access$000() ? this.createOSGiServletContext() : null;
    private final AtomicReference<Collection<Class<? extends ServletContainerInitializer>>> initializerClasses = LazyOSGiDetector.access$000() ? new AtomicReference() : null;
    private final Map<Long, Collection<Class<?>>> cachedClasses = LazyOSGiDetector.access$000() ? new ConcurrentHashMap() : null;
    private static final ResourceProvider RESOURCE_PROVIDER = new OSGiResourceProvider();

    private OSGiAccess() {
    }

    public static OSGiAccess getInstance() {
        return INSTANCE;
    }

    public ServletContext getOsgiServletContext() {
        return this.context;
    }

    public void setServletContainerInitializers(Collection<Class<? extends ServletContainerInitializer>> contextInitializers) {
        assert (contextInitializers != null);
        this.initializerClasses.set(new ArrayList<Class<? extends ServletContainerInitializer>>(contextInitializers));
    }

    public boolean hasInitializers() {
        return this.initializerClasses.get() != null;
    }

    public void addScannedClasses(Map<Long, Collection<Class<?>>> extenderClasses) {
        this.cachedClasses.putAll(extenderClasses);
        this.resetContextInitializers();
    }

    public void removeScannedClasses(Long bundleId) {
        this.cachedClasses.remove(bundleId);
        this.resetContextInitializers();
    }

    private void resetContextInitializers() {
        this.initializerClasses.get().stream().filter(clazz -> !clazz.equals(DevModeInitializer.class) && !clazz.equals(LookupServletContainerInitializer.class)).map(ReflectTools::createInstance).forEach(this::handleTypes);
    }

    private void handleTypes(ServletContainerInitializer initializer) {
        Optional<HandlesTypes> handleTypes = AnnotationReader.getAnnotationFor(initializer.getClass(), HandlesTypes.class);
        assert (initializer instanceof ClassLoaderAwareServletContainerInitializer);
        try {
            ((ClassLoaderAwareServletContainerInitializer)initializer).process(this.filterClasses(handleTypes.orElse(null)), this.getOsgiServletContext());
        }
        catch (ServletException e) {
            throw new RuntimeException("Couldn't run servlet context initializer " + initializer.getClass(), e);
        }
    }

    private Set<Class<?>> filterClasses(HandlesTypes typesAnnotation) {
        HashSet result = new HashSet();
        if (typesAnnotation == null) {
            this.cachedClasses.forEach((bundle, classes) -> result.addAll((Collection<Class<?>>)classes));
        } else {
            Class[] requestedTypes = typesAnnotation.value();
            Predicate<Class> isAnnotation = Class::isAnnotation;
            List annotations = Stream.of(requestedTypes).filter(isAnnotation).map(clazz -> clazz).collect(Collectors.toList());
            List superTypes = Stream.of(requestedTypes).filter(isAnnotation.negate()).collect(Collectors.toList());
            Predicate<Class> hasType = clazz -> annotations.stream().anyMatch(annotation -> AnnotationReader.getAnnotationFor(clazz, annotation).isPresent()) || superTypes.stream().anyMatch(superType -> GenericTypeReflector.isSuperType(HasErrorParameter.class, (Type)clazz));
            this.cachedClasses.forEach((bundle, classes) -> result.addAll(classes.stream().filter(hasType).collect(Collectors.toList())));
        }
        return result;
    }

    private ServletContext createOSGiServletContext() {
        DynamicType.Builder builder = new ByteBuddy().subclass(OSGiServletContext.class);
        Class osgiServletContextClass = builder.make().load(OSGiServletContext.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded();
        OSGiServletContext osgiContext = (OSGiServletContext)ReflectTools.createProxyInstance(osgiServletContextClass, ServletContext.class);
        new VaadinServletContext(osgiContext).setAttribute(Lookup.class, new OsgiLookupImpl());
        return osgiContext;
    }

    private static final class LazyOSGiDetector {
        private static final boolean IS_IN_OSGI = LazyOSGiDetector.isInOSGi();

        private LazyOSGiDetector() {
        }

        private static boolean isInOSGi() {
            try {
                Class<?> clazz = Class.forName("org.osgi.framework.FrameworkUtil");
                Method method = clazz.getDeclaredMethod("getBundle", Class.class);
                if (method.invoke(null, OSGiAccess.class) == null) {
                    return false;
                }
                UsageStatistics.markAsUsed("flow/osgi", LazyOSGiDetector.getOSGiVersion());
                return true;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                if (LoggerFactory.getLogger(OSGiAccess.class).isTraceEnabled()) {
                    LoggerFactory.getLogger(OSGiAccess.class).trace("Exception in OSGi container check (which most likely means that this is not OSGi container)", (Throwable)exception);
                }
                return false;
            }
        }

        private static String getOSGiVersion() {
            try {
                Bundle osgiBundle = FrameworkUtil.getBundle(Bundle.class);
                return osgiBundle.getVersion().toString();
            }
            catch (Throwable throwable) {
                LoggerFactory.getLogger(OSGiAccess.class).info("Unable to detect used OSGi framework version due to " + throwable.getMessage());
                return null;
            }
        }

        static /* synthetic */ boolean access$000() {
            return IS_IN_OSGI;
        }
    }

    public static abstract class OSGiServletContext
    implements ServletContext {
        private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();

        public void setAttribute(String name, Object object) {
            this.attributes.put(name, object);
        }

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void removeAttribute(String name) {
            this.attributes.remove(name);
        }

        public Enumeration<String> getAttributeNames() {
            return Collections.enumeration(Collections.singletonList(Lookup.class.getName()));
        }

        public void log(String msg) {
            LoggerFactory.getLogger(OSGiAccess.class).warn(msg);
        }

        public String getInitParameter(String name) {
            if ("compatibilityMode".equals(name)) {
                return Boolean.TRUE.toString();
            }
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(Collections.singletonList("compatibilityMode"));
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            return Collections.emptyMap();
        }
    }

    private static class OsgiLookupImpl
    implements Lookup {
        private OsgiLookupImpl() {
        }

        @Override
        public <T> T lookup(Class<T> serviceClass) {
            if (ResourceProvider.class.equals(serviceClass)) {
                return serviceClass.cast(RESOURCE_PROVIDER);
            }
            Bundle bundle = FrameworkUtil.getBundle(OSGiAccess.class);
            ServiceReference reference = bundle.getBundleContext().getServiceReference(serviceClass);
            if (reference == null) {
                LoggerFactory.getLogger(OsgiLookupImpl.class).debug("No service found for '{}' SPI", serviceClass);
                return null;
            }
            return (T)bundle.getBundleContext().getService(reference);
        }

        @Override
        public <T> Collection<T> lookupAll(Class<T> serviceClass) {
            Bundle bundle = FrameworkUtil.getBundle(OSGiAccess.class);
            try {
                Collection references = bundle.getBundleContext().getServiceReferences(serviceClass, null);
                ArrayList<Object> services = new ArrayList<Object>(references.size());
                for (ServiceReference reference : references) {
                    Object service = bundle.getBundleContext().getService(reference);
                    if (service == null) continue;
                    services.add(service);
                }
                return services;
            }
            catch (InvalidSyntaxException e) {
                LoggerFactory.getLogger(OsgiLookupImpl.class).error("Unexpected invalid filter expression", (Throwable)e);
                assert (false) : "Implementation error: Unexpected invalid filter exception is thrown even though the service filter is null. Check the exception and update the impl";
                return Collections.emptyList();
            }
        }
    }

    private static class OSGiResourceProvider
    implements ResourceProvider {
        private OSGiResourceProvider() {
        }

        @Override
        public List<URL> getApplicationResources(VaadinContext context, String path) throws IOException {
            if (context instanceof VaadinService) {
                return Collections.list(((VaadinService)((Object)context)).getClassLoader().getResources(path));
            }
            return Collections.list(context.getClass().getClassLoader().getResources(path));
        }

        @Override
        public URL getApplicationResource(VaadinContext context, String path) {
            Objects.requireNonNull(context);
            if (context instanceof VaadinServletContext) {
                return ((VaadinServletContext)context).getContext().getClassLoader().getResource(path);
            }
            return null;
        }

        @Override
        public URL getClientResource(String path) {
            Bundle[] bundles;
            for (Bundle bundle : bundles = FrameworkUtil.getBundle(OSGiResourceProvider.class).getBundleContext().getBundles()) {
                if (!"com.vaadin.flow.client".equals(bundle.getSymbolicName())) continue;
                return bundle.getResource(path);
            }
            return null;
        }

        @Override
        public InputStream getClientResourceAsStream(String path) throws IOException {
            return this.getClientResource(path).openStream();
        }
    }
}

