/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.templatemodel;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.templatemodel.ComplexModelType;
import com.vaadin.flow.templatemodel.PropertyFilter;
import com.vaadin.flow.templatemodel.TemplateModelListProxy;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ListModelType<T>
implements ComplexModelType<T> {
    private ComplexModelType<T> itemType;

    public ListModelType(ComplexModelType<T> itemType) {
        assert (itemType != null);
        this.itemType = itemType;
    }

    public ComplexModelType<T> getItemType() {
        return this.itemType;
    }

    @Override
    public List<T> modelToApplication(Serializable modelValue) {
        if (modelValue instanceof StateNode) {
            return new TemplateModelListProxy<T>((StateNode)modelValue, this.itemType);
        }
        throw new IllegalArgumentException(String.format("The stored model value '%s' type '%s' cannot be used as a type for a model list property", modelValue, modelValue.getClass()));
    }

    @Override
    public StateNode applicationToModel(Object applicationValue, PropertyFilter filter) {
        if (applicationValue == null) {
            return null;
        }
        StateNode node = new StateNode(Collections.singletonList(ModelList.class), new Class[0]);
        List list = (List)applicationValue;
        this.importBeans(node.getFeature(ModelList.class), list, filter);
        return node;
    }

    @Override
    public <C> ComplexModelType<C> cast(Class<C> proxyType) {
        if (this.getItemType() instanceof ListModelType && GenericTypeReflector.erase(proxyType).equals(List.class)) {
            return this;
        }
        throw new IllegalArgumentException("Got " + proxyType + ", expected list type");
    }

    public static boolean isList(Type type) {
        return type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(List.class);
    }

    public void importBeans(ModelList modelList, List<T> beans, PropertyFilter propertyFilter) {
        ArrayList<StateNode> childNodes = new ArrayList<StateNode>();
        for (T bean : beans) {
            StateNode childNode = this.itemType.applicationToModel(bean, propertyFilter);
            childNodes.add(childNode);
        }
        modelList.clear();
        modelList.addAll((Collection<? extends StateNode>)childNodes);
    }

    @Override
    public boolean accepts(Type applicationType) {
        return ListModelType.isList(applicationType);
    }

    @Override
    public Type getJavaType() {
        return ReflectTools.createParameterizedType(List.class, this.getItemType().getJavaType());
    }

    @Override
    public JsonValue toJson() {
        return JsonUtils.createArray(this.itemType.toJson());
    }

    @Override
    public void createInitialValue(StateNode node, String property) {
        node.getFeature(ElementPropertyMap.class).resolveModelList(property);
    }
}

