/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.AttachNotifier;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DetachNotifier;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.PropertyDescriptor;
import com.vaadin.flow.component.PropertyDescriptors;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementUtil;
import com.vaadin.flow.dom.ShadowRoot;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.server.Attributes;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class Component
implements HasElement,
AttachNotifier,
DetachNotifier {
    private static final PropertyDescriptor<String, Optional<String>> idDescriptor = PropertyDescriptors.optionalAttributeWithDefault("id", "");
    static ThreadLocal<MapToExistingElement> elementToMapTo = new ThreadLocal();
    private Element element;
    Attributes attributes;
    private ComponentEventBus eventBus = null;
    private final boolean templateMapped;

    protected Component() {
        Optional<String> tagNameAnnotation = AnnotationReader.getAnnotationFor(this.getClass(), Tag.class).map(Tag::value);
        if (!tagNameAnnotation.isPresent()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " (or a super class) must be annotated with @" + Tag.class.getName() + " if the default constructor is used.");
        }
        String tagName = tagNameAnnotation.get();
        if (tagName.isEmpty()) {
            throw new IllegalStateException("@" + Tag.class.getSimpleName() + " value cannot be empty.");
        }
        if (elementToMapTo.get() != null) {
            this.mapToElement(tagName);
            this.templateMapped = this.element != null && this.element.isVirtualChild();
        } else {
            Element e = new Element(tagName);
            Component.setElement(this, e);
            this.templateMapped = false;
        }
    }

    protected Component(Element element) {
        if (elementToMapTo.get() != null) {
            this.mapToElement(element == null ? null : element.getTag());
            this.templateMapped = this.element != null && this.element.isVirtualChild();
        } else {
            if (element != null) {
                Component.setElement(this, element, true);
            }
            this.templateMapped = false;
        }
    }

    private void configureSynchronizedProperties() {
        ComponentUtil.getSynchronizedProperties(this.getClass()).forEach(info -> this.getElement().addSynchronizedProperty(info.getProperty(), info.getUpdateMode()));
        ComponentUtil.getSynchronizedPropertyEvents(this.getClass()).forEach(this.getElement()::addSynchronizedPropertyEvent);
    }

    private void mapToElement(String tagName) {
        MapToExistingElement wrapData = elementToMapTo.get();
        assert (wrapData != null);
        elementToMapTo.remove();
        String elementTag = wrapData.element.getTag();
        if (tagName != null && !tagName.equalsIgnoreCase(elementTag)) {
            throw new IllegalArgumentException("A component specified to use a " + tagName + " element cannot use an element with tag name " + elementTag);
        }
        Component.setElement(this, wrapData.element, wrapData.mapElementToComponent);
    }

    @Override
    public Element getElement() {
        assert (this.element != null) : "getElement() must not be called before the element has been set";
        return this.element;
    }

    private static void setElement(Component component, Element element, boolean mapElementToComponent) {
        if (component.element != null) {
            throw new IllegalStateException("Element has already been set");
        }
        if (element == null) {
            throw new IllegalArgumentException("Element must not be null");
        }
        component.element = element;
        if (mapElementToComponent) {
            ElementUtil.setComponent(element, component);
            component.configureSynchronizedProperties();
        }
    }

    protected static void setElement(Component component, Element element) {
        Component.setElement(component, element, true);
    }

    public Optional<Component> getParent() {
        Optional<Component> mappedComponent = this.getElement().getComponent();
        if (!mappedComponent.isPresent()) {
            throw new IllegalStateException("You cannot use getParent() on a wrapped component. Use Component.wrapAndMap to include the component in the hierarchy");
        }
        if (this.isInsideComposite(mappedComponent.get())) {
            Component parent = ComponentUtil.getParentUsingComposite((Composite)mappedComponent.get(), this);
            return Optional.of(parent);
        }
        return ComponentUtil.findParentComponent(this.getElement().getParent());
    }

    private boolean isInsideComposite(Component mappedComponent) {
        return mappedComponent instanceof Composite && mappedComponent != this;
    }

    public Stream<Component> getChildren() {
        assert (!(this instanceof Composite));
        if (!this.getElement().getComponent().isPresent()) {
            throw new IllegalStateException("You cannot use getChildren() on a wrapped component. Use Component.wrapAndMap to include the component in the hierarchy");
        }
        Stream.Builder childComponents = Stream.builder();
        this.getElement().getChildren().forEach(childElement -> ComponentUtil.findComponents(childElement, childComponents::add));
        return childComponents.build();
    }

    protected ComponentEventBus getEventBus() {
        if (this.eventBus == null) {
            this.eventBus = new ComponentEventBus(this);
        }
        return this.eventBus;
    }

    protected <T extends ComponentEvent<?>> Registration addListener(Class<T> eventType, ComponentEventListener<T> listener) {
        return this.getEventBus().addListener(eventType, listener);
    }

    protected boolean hasListener(Class<? extends ComponentEvent> eventType) {
        return this.eventBus != null && this.eventBus.hasListener(eventType);
    }

    protected void fireEvent(ComponentEvent<?> componentEvent) {
        if (this.hasListener(componentEvent.getClass())) {
            this.getEventBus().fireEvent(componentEvent);
        }
    }

    public Optional<UI> getUI() {
        Optional<Component> parent = this.getParent();
        if (parent.isPresent()) {
            return parent.flatMap(Component::getUI);
        }
        if (this.getElement().getParentNode() instanceof ShadowRoot) {
            parent = ComponentUtil.findParentComponent(((ShadowRoot)this.getElement().getParentNode()).getHost());
            return parent.flatMap(Component::getUI);
        }
        return Optional.empty();
    }

    public void setId(String id) {
        this.set(idDescriptor, id);
    }

    public Optional<String> getId() {
        return this.get(idDescriptor);
    }

    protected void onAttach(AttachEvent attachEvent) {
    }

    protected void onDetach(DetachEvent detachEvent) {
    }

    public boolean isAttached() {
        return this.getElement().getNode().isAttached();
    }

    protected <T> void set(PropertyDescriptor<T, ?> descriptor, T value) {
        assert (descriptor != null);
        descriptor.set(this, value);
    }

    protected <T> T get(PropertyDescriptor<?, T> descriptor) {
        assert (descriptor != null);
        return descriptor.get(this);
    }

    public static <T extends Component> T from(Element element, Class<T> componentType) {
        return ComponentUtil.componentFromElement(element, componentType, true);
    }

    public void setVisible(boolean visible) {
        this.getElement().setVisible(visible);
    }

    public boolean isVisible() {
        return this.getElement().isVisible();
    }

    public void onEnabledStateChanged(boolean enabled) {
        if (this.getElement().getNode().hasFeature(ElementData.class)) {
            this.getElement().setAttribute("disabled", !enabled);
        }
    }

    protected boolean isTemplateMapped() {
        return this.templateMapped;
    }

    public String getTranslation(String key, Object ... params) {
        return this.getTranslation(key, this.getLocale(), params);
    }

    public String getTranslation(String key, Locale locale, Object ... params) {
        if (this.getI18NProvider() == null) {
            return "!{" + key + "}!";
        }
        return this.getI18NProvider().getTranslation(key, locale, params);
    }

    private I18NProvider getI18NProvider() {
        return VaadinService.getCurrent().getInstantiator().getI18NProvider();
    }

    protected Locale getLocale() {
        Locale locale;
        UI currentUi = UI.getCurrent();
        Locale locale2 = locale = currentUi == null ? null : currentUi.getLocale();
        if (locale == null) {
            List<Locale> locales = this.getI18NProvider().getProvidedLocales();
            locale = locales != null && !locales.isEmpty() ? locales.get(0) : Locale.getDefault();
        }
        return locale;
    }

    static class MapToExistingElement
    implements Serializable {
        Element element = null;
        private boolean mapElementToComponent = false;

        public MapToExistingElement(Element element, boolean mapElementToComponent) {
            this.element = element;
            this.mapElementToComponent = mapElementToComponent;
        }
    }
}

