/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class TaskGenerateTsDefinitions
extends AbstractTaskClientGenerator {
    static final String TS_DEFINITIONS = "types.d.ts";
    private Options options;

    TaskGenerateTsDefinitions(Options options) {
        this.options = options;
    }

    @Override
    protected String getFileContent() throws IOException {
        try (InputStream tsDefinitionStream = this.getClass().getResourceAsStream(TS_DEFINITIONS);){
            String string = IOUtils.toString((InputStream)tsDefinitionStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.options.getNpmFolder(), TS_DEFINITIONS);
    }

    @Override
    protected boolean shouldGenerate() {
        File tsDefinitionsFile = this.getGeneratedFile();
        return !tsDefinitionsFile.exists() && new File(this.options.getNpmFolder(), "tsconfig.json").exists();
    }
}

