/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.MessageDigestUtil;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class ConstantPoolKey
implements Serializable {
    private final JsonValue json;
    private String id;

    public ConstantPoolKey(JsonValue json) {
        assert (json != null);
        this.json = json;
    }

    public String getId() {
        if (this.id == null) {
            this.id = ConstantPoolKey.calculateHash(this.json);
        }
        return this.id;
    }

    public void export(JsonObject clientConstantPoolUpdate) {
        clientConstantPoolUpdate.put(this.getId(), this.json);
    }

    private static String calculateHash(JsonValue json) {
        byte[] digest = MessageDigestUtil.sha256(json.toJson());
        ByteBuffer truncatedDigest = ByteBuffer.wrap(digest, 0, 8);
        ByteBuffer base64Bytes = Base64.getEncoder().encode(truncatedDigest);
        return StandardCharsets.US_ASCII.decode(base64Bytes).toString();
    }
}

