/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.AbstractConfiguration;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractPropertyConfiguration
implements AbstractConfiguration {
    private final Map<String, String> properties;

    public AbstractPropertyConfiguration(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public String getStringProperty(String name, String defaultValue) {
        return this.getApplicationOrSystemProperty(name, defaultValue, Function.identity());
    }

    @Override
    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String booleanString = this.getStringProperty(name, null);
        if (booleanString == null) {
            return defaultValue;
        }
        if (booleanString.isEmpty()) {
            return true;
        }
        boolean parsedBoolean = Boolean.parseBoolean(booleanString);
        if (Boolean.toString(parsedBoolean).equalsIgnoreCase(booleanString)) {
            return parsedBoolean;
        }
        throw new IllegalArgumentException(String.format("Property named '%s' is boolean, but contains incorrect value '%s' that is not boolean '%s'", name, booleanString, parsedBoolean));
    }

    public String getApplicationProperty(String parameterName) {
        return this.getApplicationProperty(this.getProperties()::get, parameterName);
    }

    protected Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public <T> T getApplicationOrSystemProperty(String propertyName, T defaultValue, Function<String, T> converter) {
        String val = this.getSystemProperty(propertyName);
        if (val != null) {
            return converter.apply(val);
        }
        val = this.getApplicationProperty(propertyName);
        if (val != null) {
            return converter.apply(val);
        }
        return defaultValue;
    }

    protected String getSystemProperty(String parameterName) {
        return System.getProperty("vaadin." + parameterName);
    }

    protected String getApplicationProperty(Function<String, String> valueProvider, String propertyName) {
        String val = valueProvider.apply(propertyName);
        if (val != null) {
            return val;
        }
        val = valueProvider.apply(propertyName.toLowerCase(Locale.ENGLISH));
        return val;
    }
}

