/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.webcomponent.PropertyConfiguration;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.server.webcomponent.PropertyData;
import java.io.Serializable;
import java.util.Objects;

public final class PropertyConfigurationImpl<C extends Component, P extends Serializable>
implements PropertyConfiguration<C, P> {
    private Class<C> componentClass;
    private PropertyData<P> data;
    private SerializableBiConsumer<C, Serializable> onChangeHandler = null;

    public PropertyConfigurationImpl(Class<C> componentType, String propertyName, Class<P> propertyType, P defaultValue) {
        this.data = new PropertyData<P>(propertyName, propertyType, false, defaultValue);
        this.componentClass = componentType;
    }

    @Override
    public PropertyConfiguration<C, P> onChange(SerializableBiConsumer<C, P> onChangeHandler) {
        Objects.requireNonNull(onChangeHandler, "Parameter 'onChangeHandler' cannot be null!");
        if (this.onChangeHandler != null) {
            throw new IllegalStateException(String.format("onChangeHandler for property %s has already been set and cannot be overwritten!", this.data.getName()));
        }
        this.onChangeHandler = (c, o) -> onChangeHandler.accept(c, o);
        return this;
    }

    @Override
    public PropertyConfiguration<C, P> readOnly() {
        this.data = this.data.updateReadOnly(true);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyConfigurationImpl) {
            PropertyConfigurationImpl other = (PropertyConfigurationImpl)obj;
            return this.data.equals(other.data) && this.componentClass.equals(other.componentClass);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.componentClass, this.data);
    }

    public SerializableBiConsumer<C, Serializable> getOnChangeHandler() {
        return this.onChangeHandler;
    }

    public PropertyData<P> getPropertyData() {
        return this.data;
    }
}

