/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.function.SerializableBiConsumer;
import com.vaadin.flow.internal.LocaleUtil;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.Signal;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

public final class ComponentEffect {
    private final Runnable effectFunction;
    private boolean closed = false;
    private Runnable effectShutdown = null;

    private <C extends Component> ComponentEffect(C owner, Runnable effectFunction) {
        Objects.requireNonNull(owner, "Owner component cannot be null");
        Objects.requireNonNull(effectFunction, "Effect function cannot be null");
        this.effectFunction = effectFunction;
        owner.addAttachListener(attach -> {
            this.enableEffect();
            owner.addDetachListener(detach -> {
                this.disableEffect();
                detach.unregisterListener();
            });
        });
        if (owner.isAttached()) {
            this.enableEffect();
        }
    }

    public static <C extends Component> Registration effect(C owner, Runnable effectFunction) {
        ComponentEffect effect = new ComponentEffect(owner, effectFunction);
        return effect::close;
    }

    public static <C extends Component, T> Registration bind(C owner, Signal<T> signal, SerializableBiConsumer<C, T> setter) {
        return ComponentEffect.effect(owner, () -> setter.accept(owner, signal.value()));
    }

    public static <C extends Component> Registration format(C owner, SerializableBiConsumer<C, String> setter, Locale locale, String format, Signal<?> ... signals) {
        return ComponentEffect.effect(owner, () -> {
            Object[] values = Stream.of(signals).map(Signal::value).toArray();
            setter.accept(owner, String.format(locale, format, values));
        });
    }

    public static <C extends Component> Registration format(C owner, SerializableBiConsumer<C, String> setter, String format, Signal<?> ... signals) {
        Locale locale = LocaleUtil.getLocale();
        return ComponentEffect.format(owner, setter, locale, format, signals);
    }

    private void enableEffect() {
        if (this.closed) {
            return;
        }
        assert (this.effectShutdown == null);
        this.effectShutdown = Signal.effect((Runnable)this.effectFunction);
    }

    private void disableEffect() {
        if (this.effectShutdown != null) {
            this.effectShutdown.run();
            this.effectShutdown = null;
        }
    }

    private void close() {
        this.disableEffect();
        this.closed = true;
    }
}

