/*
 * Copyright 2000-2025 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.flow.router;

import java.io.Serializable;

import com.vaadin.flow.router.internal.ResolveRequest;

/**
 * Callback interface for resolving {@link ResolveRequest}s to new
 * {@link NavigationState}s.
 *
 * @author Vaadin Ltd
 * @since 1.0.
 */
@FunctionalInterface
public interface RouteResolver extends Serializable {

    /**
     * Resolves the given request to a new NavigationState.
     *
     * @param request
     *            the request to resolve
     * @return the newly resolved navigation state instance
     */
    NavigationState resolve(ResolveRequest request);
}
