/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentInstance
implements Serializable {
    private static final Object NULL_OBJECT = new Object();
    private static final CurrentInstance CURRENT_INSTANCE_NULL = new CurrentInstance(NULL_OBJECT);
    private final WeakReference<Object> instance;
    private static final ThreadLocal<Map<Class<?>, CurrentInstance>> instances = new ThreadLocal();

    private CurrentInstance(Object instance) {
        this.instance = new WeakReference<Object>(instance);
    }

    public static <T> T get(Class<T> type) {
        Map<Class<?>, CurrentInstance> map = instances.get();
        if (map == null) {
            return null;
        }
        CurrentInstance currentInstance = map.get(type);
        if (currentInstance != null) {
            Object value = currentInstance.instance.get();
            if (value == null) {
                CurrentInstance.removeStaleInstances(map);
                if (map.isEmpty()) {
                    instances.remove();
                }
                return null;
            }
            return type.cast(value);
        }
        return null;
    }

    private static void removeStaleInstances(Map<Class<?>, CurrentInstance> map) {
        Iterator<Map.Entry<Class<?>, CurrentInstance>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Class<?>, CurrentInstance> entry = iterator.next();
            Object instance = entry.getValue().instance.get();
            if (instance != null) continue;
            iterator.remove();
            CurrentInstance.getLogger().debug("CurrentInstance for {} has been garbage collected.", entry.getKey());
        }
    }

    public static <T> void set(Class<T> type, T instance) {
        CurrentInstance.doSet(type, instance);
    }

    private static <T> CurrentInstance doSet(Class<T> type, T instance) {
        Map<Class<?>, CurrentInstance> map = instances.get();
        CurrentInstance previousInstance = null;
        if (instance == null) {
            if (map != null) {
                previousInstance = map.remove(type);
                if (map.isEmpty()) {
                    instances.remove();
                    map = null;
                }
            }
        } else {
            assert (type.isInstance(instance)) : "Invalid instance type";
            if (map == null) {
                map = new HashMap();
                instances.set(map);
            }
            previousInstance = map.put(type, new CurrentInstance(instance));
        }
        if (previousInstance == null) {
            previousInstance = CURRENT_INSTANCE_NULL;
        }
        return previousInstance;
    }

    public static void clearAll() {
        instances.remove();
    }

    public static void restoreInstances(Map<Class<?>, CurrentInstance> old) {
        boolean removeStale = false;
        for (Map.Entry<Class<?>, CurrentInstance> entry : old.entrySet()) {
            Class<?> c = entry.getKey();
            CurrentInstance ci = entry.getValue();
            Object v = ci.instance.get();
            if (v == null) {
                removeStale = true;
            } else if (v == NULL_OBJECT) {
                v = null;
            }
            CurrentInstance.set(c, v);
        }
        if (removeStale) {
            CurrentInstance.removeStaleInstances(old);
        }
    }

    public static Map<Class<?>, CurrentInstance> getInstances() {
        Map<Class<?>, CurrentInstance> map = instances.get();
        if (map == null) {
            return Collections.emptyMap();
        }
        HashMap copy = new HashMap();
        boolean removeStale = false;
        for (Map.Entry<Class<?>, CurrentInstance> entry : map.entrySet()) {
            Class<?> c = entry.getKey();
            CurrentInstance ci = entry.getValue();
            if (ci.instance.get() == null) {
                removeStale = true;
                continue;
            }
            copy.put(c, ci);
        }
        if (removeStale) {
            CurrentInstance.removeStaleInstances(map);
            if (map.isEmpty()) {
                instances.remove();
            }
        }
        return copy;
    }

    public static Map<Class<?>, CurrentInstance> setCurrent(UI ui) {
        Map<Class<?>, CurrentInstance> old = CurrentInstance.setCurrent(ui.getSession());
        old.put(UI.class, CurrentInstance.doSet(UI.class, ui));
        return old;
    }

    public static Map<Class<?>, CurrentInstance> setCurrent(VaadinSession session) {
        HashMap old = new HashMap();
        old.put(VaadinSession.class, CurrentInstance.doSet(VaadinSession.class, session));
        VaadinService service = null;
        if (session != null) {
            service = session.getService();
        }
        old.put(VaadinService.class, CurrentInstance.doSet(VaadinService.class, service));
        return old;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)CurrentInstance.class.getName());
    }
}

