/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.shared;

import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

@FunctionalInterface
public interface Registration
extends Serializable {
    public void remove();

    public static Registration once(final Command command) {
        Objects.requireNonNull(command);
        return new Registration(){
            private boolean removed = false;

            @Override
            public void remove() {
                if (!this.removed) {
                    this.removed = true;
                    command.execute();
                }
            }
        };
    }

    public static Registration combine(Registration ... registrations) {
        Objects.requireNonNull(registrations);
        Arrays.asList(registrations).forEach(Objects::requireNonNull);
        return () -> Arrays.asList(registrations).forEach(Registration::remove);
    }

    public static <T> Registration addAndRemove(Collection<T> collection, T item) {
        collection.add(item);
        return () -> collection.remove(item);
    }
}

