/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.UI;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

class Direction
implements Serializable {
    private static final Set<String> rtlSet;

    Direction() {
    }

    static void set(UI ui, Locale locale) {
        ui.getElement().executeJs("document.querySelector('html').dir=$0", new Serializable[]{Direction.getDirectionForLocale(locale)});
    }

    public static String getDirectionForLocale(Locale locale) {
        return rtlSet.contains(locale.getLanguage()) ? "rtl" : "ltr";
    }

    static {
        HashSet<String> lang = new HashSet<String>();
        lang.add("ar");
        lang.add("dv");
        lang.add("fa");
        lang.add("ha");
        lang.add("he");
        lang.add("iw");
        lang.add("ji");
        lang.add("ps");
        lang.add("sd");
        lang.add("ug");
        lang.add("ur");
        lang.add("yi");
        rtlSet = Collections.unmodifiableSet(lang);
    }
}

