/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.server.Version;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class UsageStatistics {
    private static ConcurrentHashMap<String, UsageEntry> entires = new ConcurrentHashMap();

    private UsageStatistics() {
    }

    public static void markAsUsed(String name, String version) {
        assert (name != null);
        entires.computeIfAbsent(name, ignore -> new UsageEntry(name, version));
    }

    public static Stream<UsageEntry> getEntries() {
        return entires.values().stream();
    }

    public static void removeEntry(String name) {
        entires.remove(name);
    }

    static {
        String version = System.getProperty("java.version");
        version = version.replaceAll("[-_+].*", "");
        UsageStatistics.markAsUsed("java", version);
    }

    public static class UsageEntry {
        private final String name;
        private final String version;

        private UsageEntry(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            if (this.version == null) {
                return Version.getFullVersion();
            }
            return this.version;
        }
    }
}

