/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.ExtendedClientDetails;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.PreserveOnRefresh;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AfterNavigationHandler;
import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import com.vaadin.flow.router.internal.Postpone;
import com.vaadin.flow.server.VaadinSession;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractNavigationStateRenderer
implements NavigationHandler {
    private static List<Integer> statusCodes = ReflectTools.getConstantIntValues(HttpServletResponse.class);
    private final NavigationState navigationState;
    private Postpone postponed = null;
    private LocationChangeEvent locationChangeEvent = null;

    public AbstractNavigationStateRenderer(NavigationState navigationState) {
        this.navigationState = navigationState;
    }

    public NavigationState getNavigationState() {
        return this.navigationState;
    }

    static <T extends HasElement> T getRouteTarget(Class<T> routeTargetType, NavigationEvent event) {
        UI ui = event.getUI();
        Optional<HasElement> currentInstance = ui.getInternals().getActiveRouterTargetsChain().stream().filter(component -> component.getClass().equals(routeTargetType)).findAny();
        return (T)currentInstance.orElseGet(() -> Instantiator.get(ui).createRouteTarget(routeTargetType, event));
    }

    @Override
    public int handle(NavigationEvent event) {
        ArrayList<HasElement> chain;
        TransitionOutcome transitionOutcome;
        Optional<Integer> result;
        Deque<BeforeLeaveHandler> leaveHandlers;
        UI ui = event.getUI();
        Class<? extends Component> routeTargetType = this.navigationState.getNavigationTarget();
        List<Class<? extends RouterLayout>> routeLayoutTypes = this.getRouterLayoutTypes(routeTargetType, ui.getRouter());
        assert (routeTargetType != null);
        assert (routeLayoutTypes != null);
        this.clearContinueNavigationAction(ui);
        AbstractNavigationStateRenderer.checkForDuplicates(routeTargetType, routeLayoutTypes);
        BeforeLeaveEvent beforeNavigationDeactivating = new BeforeLeaveEvent(event, routeTargetType, routeLayoutTypes);
        if (this.postponed != null) {
            leaveHandlers = this.postponed.getLeaveObservers();
            if (!leaveHandlers.isEmpty()) {
                this.postponed = null;
            }
        } else {
            ArrayList<BeforeLeaveHandler> beforeLeaveHandlers = new ArrayList<BeforeLeaveHandler>(ui.getNavigationListeners(BeforeLeaveHandler.class));
            beforeLeaveHandlers.addAll(EventUtil.collectBeforeLeaveObservers(ui));
            leaveHandlers = new ArrayDeque<BeforeLeaveHandler>(beforeLeaveHandlers);
        }
        if ((result = this.handleTransactionOutcome(transitionOutcome = this.executeBeforeLeaveNavigation(beforeNavigationDeactivating, leaveHandlers), event, beforeNavigationDeactivating)).isPresent()) {
            return result.get();
        }
        if (transitionOutcome == TransitionOutcome.POSTPONED) {
            BeforeLeaveEvent.ContinueNavigationAction currentAction = beforeNavigationDeactivating.getContinueNavigationAction();
            currentAction.setReferences(this, event);
            this.storeContinueNavigationAction(ui, currentAction);
            return 200;
        }
        boolean preserveOnRefreshTarget = AbstractNavigationStateRenderer.isPreserveOnRefreshTarget(routeTargetType, routeLayoutTypes);
        if (preserveOnRefreshTarget) {
            Optional<ArrayList<HasElement>> maybeChain = this.getPreservedChain(event);
            if (!maybeChain.isPresent()) {
                return 200;
            }
            chain = maybeChain.get();
        } else {
            chain = new ArrayList();
            AbstractNavigationStateRenderer.clearAllPreservedChains(ui);
        }
        BeforeEnterEvent beforeNavigationActivating = new BeforeEnterEvent(event, routeTargetType, routeLayoutTypes);
        transitionOutcome = this.createChainIfEmptyAndExecuteBeforeEnterNavigation(beforeNavigationActivating, event, chain);
        result = this.handleTransactionOutcome(transitionOutcome, event, beforeNavigationActivating);
        if (result.isPresent()) {
            return result.get();
        }
        Component componentInstance = (Component)chain.get(0);
        if (preserveOnRefreshTarget) {
            this.setPreservedChain(chain, event);
        }
        List<HasElement> routerLayouts = chain.subList(1, chain.size());
        ui.getInternals().showRouteTarget(event.getLocation(), this.navigationState.getResolvedPath(), componentInstance, routerLayouts);
        AbstractNavigationStateRenderer.updatePageTitle(event, componentInstance);
        int statusCode = this.locationChangeEvent.getStatusCode();
        AbstractNavigationStateRenderer.validateStatusCode(statusCode, routeTargetType);
        ArrayList<AfterNavigationHandler> afterNavigationHandlers = new ArrayList<AfterNavigationHandler>(ui.getNavigationListeners(AfterNavigationHandler.class));
        afterNavigationHandlers.addAll(EventUtil.collectAfterNavigationObservers(ui));
        this.fireAfterNavigationListeners(new AfterNavigationEvent(this.locationChangeEvent), afterNavigationHandlers);
        return statusCode;
    }

    protected abstract void notifyNavigationTarget(Component var1, NavigationEvent var2, BeforeEnterEvent var3, LocationChangeEvent var4);

    protected abstract List<Class<? extends RouterLayout>> getRouterLayoutTypes(Class<? extends Component> var1, Router var2);

    private Optional<Integer> handleTransactionOutcome(TransitionOutcome transitionOutcome, NavigationEvent event, BeforeEvent beforeNavigation) {
        if (TransitionOutcome.FORWARDED.equals((Object)transitionOutcome)) {
            return Optional.of(this.forward(event, beforeNavigation));
        }
        if (TransitionOutcome.REROUTED.equals((Object)transitionOutcome)) {
            return Optional.of(this.reroute(event, beforeNavigation));
        }
        return Optional.empty();
    }

    private List<Class<? extends HasElement>> createTypesChain(NavigationEvent event) {
        Class<? extends Component> routeTargetType = this.navigationState.getNavigationTarget();
        ArrayList<Class<? extends RouterLayout>> routeLayoutTypes = new ArrayList<Class<? extends RouterLayout>>(this.getRouterLayoutTypes(routeTargetType, event.getUI().getRouter()));
        Collections.reverse(routeLayoutTypes);
        ArrayList<Class<? extends HasElement>> chain = new ArrayList<Class<? extends HasElement>>();
        for (Class clazz : routeLayoutTypes) {
            chain.add(clazz);
        }
        chain.add(routeTargetType);
        return chain;
    }

    private void clearContinueNavigationAction(UI ui) {
        this.storeContinueNavigationAction(ui, null);
    }

    private void storeContinueNavigationAction(UI ui, BeforeLeaveEvent.ContinueNavigationAction currentAction) {
        BeforeLeaveEvent.ContinueNavigationAction previousAction = ui.getInternals().getContinueNavigationAction();
        if (previousAction != null && previousAction != currentAction) {
            previousAction.setReferences(null, null);
        }
        ui.getInternals().setContinueNavigationAction(currentAction);
    }

    private void fireAfterNavigationListeners(AfterNavigationEvent event, List<AfterNavigationHandler> afterNavigationHandlers) {
        afterNavigationHandlers.forEach(listener -> listener.afterNavigation(event));
    }

    private TransitionOutcome executeBeforeLeaveNavigation(BeforeLeaveEvent beforeNavigation, Deque<BeforeLeaveHandler> leaveHandlers) {
        while (!leaveHandlers.isEmpty()) {
            BeforeLeaveHandler listener = leaveHandlers.remove();
            listener.beforeLeave(beforeNavigation);
            AbstractNavigationStateRenderer.validateBeforeEvent(beforeNavigation);
            Optional<TransitionOutcome> transitionOutcome = this.getTransitionOutcome(beforeNavigation);
            if (transitionOutcome.isPresent()) {
                return transitionOutcome.get();
            }
            if (!beforeNavigation.isPostponed()) continue;
            this.postponed = Postpone.withLeaveObservers(leaveHandlers);
            return TransitionOutcome.POSTPONED;
        }
        return TransitionOutcome.FINISHED;
    }

    private TransitionOutcome createChainIfEmptyAndExecuteBeforeEnterNavigation(BeforeEnterEvent beforeNavigation, NavigationEvent event, List<HasElement> chain) {
        ArrayList<BeforeEnterHandler> registeredEnterHandlers = new ArrayList<BeforeEnterHandler>(beforeNavigation.getUI().getNavigationListeners(BeforeEnterHandler.class));
        Optional<TransitionOutcome> transitionOutcome = this.sendBeforeEnterEvent(registeredEnterHandlers, event, beforeNavigation, null);
        if (transitionOutcome.isPresent()) {
            return transitionOutcome.get();
        }
        if (chain.isEmpty()) {
            return this.sendBeforeEnterEventAndPopulateChain(beforeNavigation, event, chain);
        }
        return this.sendBeforeEnterEventToExistingChain(beforeNavigation, event, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransitionOutcome sendBeforeEnterEventAndPopulateChain(BeforeEnterEvent beforeNavigation, NavigationEvent event, List<HasElement> chain) {
        List<HasElement> oldChain = event.getUI().getInternals().getActiveRouterTargetsChain();
        List<Class<? extends HasElement>> typesChain = this.createTypesChain(event);
        try {
            for (Class<? extends HasElement> elementType : typesChain) {
                HasElement element = AbstractNavigationStateRenderer.getRouteTarget(elementType, event);
                chain.add(element);
                ArrayList<BeforeEnterHandler> chainEnterHandlers = new ArrayList<BeforeEnterHandler>(EventUtil.collectBeforeEnterObserversFromChainElement(element, oldChain));
                boolean lastElement = chain.size() == typesChain.size();
                Optional<TransitionOutcome> transitionOutcome = this.sendBeforeEnterEvent(chainEnterHandlers, event, beforeNavigation, lastElement ? chain : null);
                if (!transitionOutcome.isPresent()) continue;
                TransitionOutcome transitionOutcome2 = transitionOutcome.get();
                return transitionOutcome2;
            }
            Object object = TransitionOutcome.FINISHED;
            return object;
        }
        finally {
            Collections.reverse(chain);
        }
    }

    private TransitionOutcome sendBeforeEnterEventToExistingChain(BeforeEnterEvent beforeNavigation, NavigationEvent event, List<HasElement> chain) {
        chain = new ArrayList<HasElement>(chain);
        Collections.reverse(chain);
        ArrayList<BeforeEnterHandler> chainEnterHandlers = new ArrayList<BeforeEnterHandler>(EventUtil.collectBeforeEnterObserversFromChain(chain, event.getUI().getInternals().getActiveRouterTargetsChain()));
        Optional<TransitionOutcome> transitionOutcome = this.sendBeforeEnterEvent(chainEnterHandlers, event, beforeNavigation, chain);
        if (transitionOutcome.isPresent()) {
            return transitionOutcome.get();
        }
        return TransitionOutcome.FINISHED;
    }

    private Optional<TransitionOutcome> sendBeforeEnterEvent(List<BeforeEnterHandler> eventHandlers, NavigationEvent event, BeforeEnterEvent beforeNavigation, List<HasElement> chain) {
        Optional<TransitionOutcome> transitionOutcome;
        Component componentInstance = null;
        boolean notifyNavigationTarget = false;
        if (chain != null) {
            chain = new ArrayList<HasElement>(chain);
            Collections.reverse(chain);
            componentInstance = (Component)chain.get(0);
            this.locationChangeEvent = new LocationChangeEvent(event.getSource(), event.getUI(), event.getTrigger(), event.getLocation(), chain);
            notifyNavigationTarget = true;
        }
        for (BeforeEnterHandler eventHandler : eventHandlers) {
            Optional<TransitionOutcome> transitionOutcome2;
            if (notifyNavigationTarget && AbstractNavigationStateRenderer.isComponentElementEqualsOrChild(eventHandler, componentInstance)) {
                transitionOutcome2 = this.notifyNavigationTarget(event, beforeNavigation, this.locationChangeEvent, componentInstance);
                if (transitionOutcome2.isPresent()) {
                    return transitionOutcome2;
                }
                notifyNavigationTarget = false;
            }
            if (!(transitionOutcome2 = this.sendBeforeEnterEvent(beforeNavigation, eventHandler)).isPresent()) continue;
            return transitionOutcome2;
        }
        if (notifyNavigationTarget && (transitionOutcome = this.notifyNavigationTarget(event, beforeNavigation, this.locationChangeEvent, componentInstance)).isPresent()) {
            return transitionOutcome;
        }
        return Optional.empty();
    }

    private Optional<TransitionOutcome> sendBeforeEnterEvent(BeforeEnterEvent beforeNavigation, BeforeEnterHandler eventHandler) {
        eventHandler.beforeEnter(beforeNavigation);
        AbstractNavigationStateRenderer.validateBeforeEvent(beforeNavigation);
        return this.getTransitionOutcome(beforeNavigation);
    }

    private Optional<TransitionOutcome> notifyNavigationTarget(NavigationEvent event, BeforeEnterEvent beforeNavigation, LocationChangeEvent locationChangeEvent, Component componentInstance) {
        this.notifyNavigationTarget(componentInstance, event, beforeNavigation, locationChangeEvent);
        return this.getTransitionOutcome(beforeNavigation);
    }

    private static boolean isComponentElementEqualsOrChild(BeforeEnterHandler eventHandler, Component component) {
        if (eventHandler instanceof HasElement) {
            HasElement hasElement = (HasElement)((Object)eventHandler);
            Element componentElement = component.getElement();
            for (Element element = hasElement.getElement(); element != null; element = element.getParent()) {
                if (!element.equals(componentElement)) continue;
                return true;
            }
        }
        return false;
    }

    private Optional<TransitionOutcome> getTransitionOutcome(BeforeEvent beforeEvent) {
        if (beforeEvent.hasForwardTarget() && !this.isSameNavigationState(beforeEvent.getForwardTargetType(), beforeEvent.getForwardTargetParameters())) {
            return Optional.of(TransitionOutcome.FORWARDED);
        }
        if (beforeEvent.hasRerouteTarget() && !this.isSameNavigationState(beforeEvent.getRerouteTargetType(), beforeEvent.getRerouteTargetParameters())) {
            return Optional.of(TransitionOutcome.REROUTED);
        }
        return Optional.empty();
    }

    private boolean isSameNavigationState(Class<? extends Component> targetType, List<String> targetParameters) {
        boolean sameTarget = this.navigationState.getNavigationTarget().equals(targetType);
        boolean sameParameters = targetParameters.equals(this.navigationState.getUrlParameters().orElse(Collections.emptyList()));
        return sameTarget && sameParameters;
    }

    private int forward(NavigationEvent event, BeforeEvent beforeNavigation) {
        NavigationHandler handler = beforeNavigation.getForwardTarget();
        NavigationEvent newNavigationEvent = this.getNavigationEvent(event, beforeNavigation);
        newNavigationEvent.getUI().getPage().getHistory().replaceState(null, newNavigationEvent.getLocation());
        return handler.handle(newNavigationEvent);
    }

    private int reroute(NavigationEvent event, BeforeEvent beforeNavigation) {
        NavigationHandler handler = beforeNavigation.getRerouteTarget();
        NavigationEvent newNavigationEvent = this.getNavigationEvent(event, beforeNavigation);
        return handler.handle(newNavigationEvent);
    }

    private NavigationEvent getNavigationEvent(NavigationEvent event, BeforeEvent beforeNavigation) {
        if (beforeNavigation.hasErrorParameter()) {
            ErrorParameter<?> errorParameter = beforeNavigation.getErrorParameter();
            return new ErrorNavigationEvent(event.getSource(), event.getLocation(), event.getUI(), NavigationTrigger.PROGRAMMATIC, errorParameter);
        }
        Class<? extends Component> targetType = beforeNavigation.hasForwardTarget() ? beforeNavigation.getForwardTargetType() : beforeNavigation.getRerouteTargetType();
        Location location = new Location(RouteConfiguration.forRegistry(event.getSource().getRegistry()).getUrlBase(targetType).orElseThrow(() -> new IllegalStateException(String.format("The target component '%s' has no registered route", targetType))), event.getLocation().getQueryParameters());
        if (beforeNavigation.hasForwardTarget()) {
            ArrayList<String> segments = new ArrayList<String>(location.getSegments());
            segments.addAll(beforeNavigation.getForwardTargetParameters());
            location = new Location(segments);
        }
        return new NavigationEvent(event.getSource(), location, event.getUI(), NavigationTrigger.PROGRAMMATIC);
    }

    private Optional<ArrayList<HasElement>> getPreservedChain(NavigationEvent event) {
        Location location = event.getLocation();
        UI ui = event.getUI();
        VaadinSession session = ui.getSession();
        if (ui.getInternals().getExtendedClientDetails() == null) {
            if (AbstractNavigationStateRenderer.hasPreservedChainOfLocation(session, location)) {
                ui.getPage().retrieveExtendedClientDetails(details -> this.handle(event));
                return Optional.empty();
            }
        } else {
            String windowName = ui.getInternals().getExtendedClientDetails().getWindowName();
            Optional<ArrayList<HasElement>> maybePreserved = AbstractNavigationStateRenderer.getPreservedChain(session, windowName, event.getLocation());
            if (maybePreserved.isPresent()) {
                ArrayList<HasElement> chain = maybePreserved.get();
                HasElement root = chain.get(chain.size() - 1);
                Component component = (Component)chain.get(0);
                Optional<UI> maybePrevUI = component.getUI();
                root.getElement().removeFromTree();
                maybePrevUI.ifPresent(prevUi -> ui.getInternals().moveElementsFrom((UI)prevUi));
                return Optional.of(chain);
            }
        }
        return Optional.of(new ArrayList(0));
    }

    private void setPreservedChain(ArrayList<HasElement> chain, NavigationEvent event) {
        Location location = event.getLocation();
        UI ui = event.getUI();
        VaadinSession session = ui.getSession();
        ExtendedClientDetails extendedClientDetails = ui.getInternals().getExtendedClientDetails();
        if (extendedClientDetails == null) {
            ui.getPage().retrieveExtendedClientDetails(details -> AbstractNavigationStateRenderer.setPreservedChain(session, details.getWindowName(), location, chain));
        } else {
            String windowName = extendedClientDetails.getWindowName();
            AbstractNavigationStateRenderer.setPreservedChain(session, windowName, location, chain);
        }
    }

    private static void validateStatusCode(int statusCode, Class<? extends Component> targetClass) {
        if (!statusCodes.contains(statusCode)) {
            String msg = String.format("Error state code must be a valid HttpServletResponse value. Received invalid value of '%s' for '%s'", statusCode, targetClass.getName());
            throw new IllegalStateException(msg);
        }
    }

    private static void validateBeforeEvent(BeforeEvent event) {
        if (event.hasForwardTarget() && event.hasRerouteTarget()) {
            throw new IllegalStateException("Error forward & reroute can not be set at the same time");
        }
    }

    private static void checkForDuplicates(Class<? extends Component> routeTargetType, Collection<Class<? extends RouterLayout>> routeLayoutTypes) {
        HashSet<Class<HasElement>> duplicateCheck = new HashSet<Class<HasElement>>();
        duplicateCheck.add(routeTargetType);
        for (Class<? extends RouterLayout> parentType : routeLayoutTypes) {
            if (duplicateCheck.add(parentType)) continue;
            throw new IllegalArgumentException(parentType + " is used in multiple locations");
        }
    }

    private static void updatePageTitle(NavigationEvent navigationEvent, Component routeTarget) {
        String title = routeTarget instanceof HasDynamicTitle ? ((HasDynamicTitle)((Object)routeTarget)).getPageTitle() : AbstractNavigationStateRenderer.lookForTitleInTarget(routeTarget).map(PageTitle::value).orElse("");
        navigationEvent.getUI().getPage().setTitle(title);
    }

    private static Optional<PageTitle> lookForTitleInTarget(Component routeTarget) {
        return Optional.ofNullable(routeTarget.getClass().getAnnotation(PageTitle.class));
    }

    private static boolean isPreserveOnRefreshTarget(Class<? extends Component> routeTargetType, List<Class<? extends RouterLayout>> routeLayoutTypes) {
        return routeTargetType.isAnnotationPresent(PreserveOnRefresh.class) || routeLayoutTypes.stream().anyMatch(layoutType -> layoutType.isAnnotationPresent(PreserveOnRefresh.class));
    }

    static boolean hasPreservedChain(VaadinSession session) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        return cache != null && !cache.isEmpty();
    }

    static boolean hasPreservedChainOfLocation(VaadinSession session, Location location) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        return cache != null && cache.values().stream().anyMatch(entry -> ((String)entry.getFirst()).equals(location.getPath()));
    }

    static Optional<ArrayList<HasElement>> getPreservedChain(VaadinSession session, String windowName, Location location) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        if (cache != null && cache.containsKey(windowName) && ((String)((Pair)cache.get(windowName)).getFirst()).equals(location.getPath())) {
            return Optional.of(((Pair)cache.get(windowName)).getSecond());
        }
        return Optional.empty();
    }

    static void setPreservedChain(VaadinSession session, String windowName, Location location, ArrayList<HasElement> chain) {
        PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
        if (cache == null) {
            cache = new PreservedComponentCache();
        }
        cache.put(windowName, new Pair<String, ArrayList<HasElement>>(location.getPath(), chain));
        session.setAttribute(PreservedComponentCache.class, cache);
    }

    private static void clearAllPreservedChains(UI ui) {
        VaadinSession session = ui.getSession();
        if (AbstractNavigationStateRenderer.hasPreservedChain(session)) {
            ui.getPage().retrieveExtendedClientDetails(details -> {
                String windowName = ui.getInternals().getExtendedClientDetails().getWindowName();
                PreservedComponentCache cache = session.getAttribute(PreservedComponentCache.class);
                if (cache != null) {
                    cache.remove(windowName);
                }
            });
        }
    }

    private static class PreservedComponentCache
    extends HashMap<String, Pair<String, ArrayList<HasElement>>> {
        private PreservedComponentCache() {
        }
    }

    private static enum TransitionOutcome {
        FORWARDED,
        FINISHED,
        REROUTED,
        POSTPONED;

    }
}

